/*
 * #%L
 * Pollen :: Services
 * 
 * $Id: PollenServiceContext.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-services/src/main/java/org/chorem/pollen/services/PollenServiceContext.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.pollen.services;

import org.chorem.pollen.PollenConfiguration;
import org.nuiton.topia.TopiaContext;

import java.net.URL;
import java.util.Date;
import java.util.Locale;

/**
 * This contract represents objects you must provide when asking for a service.
 * Objects provided may be injected in services returned by
 * {@link PollenServiceFactory#newService(Class, PollenServiceContext)}
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public interface PollenServiceContext {

    TopiaContext getTransaction();

    void setTransaction(TopiaContext transaction);

    Locale getLocale();

    URL getApplicationURL();

    PollenConfiguration getConfiguration();

    PollenServiceFactory getServiceFactory();

    <E extends PollenService> E newService(Class<E> clazz);

    /**
     * createPollenUrlId :
     * Create a unique UId for entities which need it (PollAccount, Poll).
     * This UId represent the entity in UI module.
     *
     * @return String
     */
    String createPollenUrlId();

    /** @return the current date */
    Date getCurrentTime();

}
