/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PollAccountDAOAbstract<E extends PollAccount>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return PollAccount.class;
    }

    public PollenDAOHelper.PollenEntityEnum getTopiaEntityEnum() {
        return PollenDAOHelper.PollenEntityEnum.PollAccount;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(Poll.class).findAllByProperties("creator", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getCreator())) continue;
            item.setCreator(null);
        }
        list = this.getContext().getDAO(Comment.class).findAllByProperties("pollAccount", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getPollAccount())) continue;
            item.setPollAccount(null);
        }
        list = this.getContext().getDAO(Vote.class).findAllByProperties("pollAccount", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getPollAccount())) continue;
            item.setPollAccount(null);
        }
        super.delete(entity);
    }

    public E findByAccountId(String v) throws TopiaException {
        PollAccount result = (PollAccount)this.findByProperty("accountId", v);
        return (E)result;
    }

    public List<E> findAllByAccountId(String v) throws TopiaException {
        List result = this.findAllByProperty("accountId", v);
        return result;
    }

    public E findByVotingId(String v) throws TopiaException {
        PollAccount result = (PollAccount)this.findByProperty("votingId", v);
        return (E)result;
    }

    public List<E> findAllByVotingId(String v) throws TopiaException {
        List result = this.findAllByProperty("votingId", v);
        return result;
    }

    public E findByEmail(String v) throws TopiaException {
        PollAccount result = (PollAccount)this.findByProperty("email", v);
        return (E)result;
    }

    public List<E> findAllByEmail(String v) throws TopiaException {
        List result = this.findAllByProperty("email", v);
        return result;
    }

    public E findContainsVote(Vote v) throws TopiaException {
        PollAccount result = (PollAccount)this.findContains("vote", v);
        return (E)result;
    }

    public List<E> findAllContainsVote(Vote v) throws TopiaException {
        List result = this.findAllContains("vote", v);
        return result;
    }

    public E findByPersonList(PersonList v) throws TopiaException {
        PollAccount result = (PollAccount)this.findByProperty("personList", v);
        return (E)result;
    }

    public List<E> findAllByPersonList(PersonList v) throws TopiaException {
        List result = this.findAllByProperty("personList", v);
        return result;
    }

    public E findByUserAccount(UserAccount v) throws TopiaException {
        PollAccount result = (PollAccount)this.findByProperty("userAccount", v);
        return (E)result;
    }

    public List<E> findAllByUserAccount(UserAccount v) throws TopiaException {
        List result = this.findAllByProperty("userAccount", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == Comment.class) {
            dao = (CommentDAO)this.getContext().getDAO(Comment.class);
            tmp = dao.findAllByPollAccount((PollAccount)entity);
            result.addAll(tmp);
        }
        if (type == Vote.class) {
            dao = (VoteDAO)this.getContext().getDAO(Vote.class);
            tmp = dao.findAllByPollAccount((PollAccount)entity);
            result.addAll(tmp);
        }
        if (type == UserAccount.class) {
            dao = (UserAccountDAO)this.getContext().getDAO(UserAccount.class);
            tmp = dao.findAllContainsPollAccount((PollAccount)entity);
            result.addAll(tmp);
        }
        if (type == Poll.class) {
            dao = (PollDAO)this.getContext().getDAO(Poll.class);
            tmp = dao.findAllByCreator((PollAccount)entity);
            result.addAll(tmp);
        }
        if (type == PersonList.class) {
            dao = (PersonListDAO)this.getContext().getDAO(PersonList.class);
            tmp = dao.findAllContainsPollAccount((PollAccount)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(5);
        List<Object> list = this.findUsages(Comment.class, entity);
        if (!list.isEmpty()) {
            result.put(Comment.class, list);
        }
        if (!(list = this.findUsages(Vote.class, entity)).isEmpty()) {
            result.put(Vote.class, list);
        }
        if (!(list = this.findUsages(UserAccount.class, entity)).isEmpty()) {
            result.put(UserAccount.class, list);
        }
        if (!(list = this.findUsages(Poll.class, entity)).isEmpty()) {
            result.put(Poll.class, list);
        }
        if (!(list = this.findUsages(PersonList.class, entity)).isEmpty()) {
            result.put(PersonList.class, list);
        }
        return result;
    }
}

