/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PersonListDAOAbstract<E extends PersonList>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return PersonList.class;
    }

    public PollenDAOHelper.PollenEntityEnum getTopiaEntityEnum() {
        return PollenDAOHelper.PollenEntityEnum.PersonList;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(PollAccount.class).findAllByProperties("personList", entity, new Object[0]);
        for (PollAccount item : list) {
            if (!entity.equals(item.getPersonList())) continue;
            item.setPersonList(null);
        }
        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        PersonList result = (PersonList)this.findByProperty("name", v);
        return (E)result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List result = this.findAllByProperty("name", v);
        return result;
    }

    public E findByOwner(UserAccount v) throws TopiaException {
        PersonList result = (PersonList)this.findByProperty("owner", v);
        return (E)result;
    }

    public List<E> findAllByOwner(UserAccount v) throws TopiaException {
        List result = this.findAllByProperty("owner", v);
        return result;
    }

    public E findContainsPollAccount(PollAccount v) throws TopiaException {
        PersonList result = (PersonList)this.findContains("pollAccount", v);
        return (E)result;
    }

    public List<E> findAllContainsPollAccount(PollAccount v) throws TopiaException {
        List result = this.findAllContains("pollAccount", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == PollAccount.class) {
            dao = (PollAccountDAO)this.getContext().getDAO(PollAccount.class);
            tmp = dao.findAllByPersonList((PersonList)entity);
            result.addAll(tmp);
        }
        if (type == UserAccount.class) {
            dao = (UserAccountDAO)this.getContext().getDAO(UserAccount.class);
            tmp = dao.findAllContainsFavoriteList((PersonList)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        List<Object> list = this.findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }
        if (!(list = this.findUsages(UserAccount.class, entity)).isEmpty()) {
            result.put(UserAccount.class, list);
        }
        return result;
    }
}

