/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class UserAccountAbstract
extends TopiaEntityAbstract
implements UserAccount {
    protected String login;
    protected String password;
    protected String firstName;
    protected String lastName;
    protected boolean administrator;
    protected String language;
    protected String email;
    protected List<PersonList> favoriteList;
    protected List<PollAccount> pollAccount;
    private static final long serialVersionUID = 3775477073812284720L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "login", String.class, (Object)this.login);
        visitor.visit((TopiaEntity)this, "password", String.class, (Object)this.password);
        visitor.visit((TopiaEntity)this, "firstName", String.class, (Object)this.firstName);
        visitor.visit((TopiaEntity)this, "lastName", String.class, (Object)this.lastName);
        visitor.visit((TopiaEntity)this, "administrator", Boolean.TYPE, (Object)this.administrator);
        visitor.visit((TopiaEntity)this, "language", String.class, (Object)this.language);
        visitor.visit((TopiaEntity)this, "email", String.class, (Object)this.email);
        visitor.visit((TopiaEntity)this, "favoriteList", List.class, PersonList.class, this.favoriteList);
        visitor.visit((TopiaEntity)this, "pollAccount", List.class, PollAccount.class, this.pollAccount);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        this.fireOnPreWrite("login", oldValue, login);
        this.login = login;
        this.fireOnPostWrite("login", oldValue, login);
    }

    @Override
    public String getLogin() {
        this.fireOnPreRead("login", this.login);
        String result = this.login;
        this.fireOnPostRead("login", this.login);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        this.fireOnPreWrite("password", oldValue, password);
        this.password = password;
        this.fireOnPostWrite("password", oldValue, password);
    }

    @Override
    public String getPassword() {
        this.fireOnPreRead("password", this.password);
        String result = this.password;
        this.fireOnPostRead("password", this.password);
        return result;
    }

    @Override
    public void setFirstName(String firstName) {
        String oldValue = this.firstName;
        this.fireOnPreWrite("firstName", oldValue, firstName);
        this.firstName = firstName;
        this.fireOnPostWrite("firstName", oldValue, firstName);
    }

    @Override
    public String getFirstName() {
        this.fireOnPreRead("firstName", this.firstName);
        String result = this.firstName;
        this.fireOnPostRead("firstName", this.firstName);
        return result;
    }

    @Override
    public void setLastName(String lastName) {
        String oldValue = this.lastName;
        this.fireOnPreWrite("lastName", oldValue, lastName);
        this.lastName = lastName;
        this.fireOnPostWrite("lastName", oldValue, lastName);
    }

    @Override
    public String getLastName() {
        this.fireOnPreRead("lastName", this.lastName);
        String result = this.lastName;
        this.fireOnPostRead("lastName", this.lastName);
        return result;
    }

    @Override
    public void setAdministrator(boolean administrator) {
        boolean oldValue = this.administrator;
        this.fireOnPreWrite("administrator", oldValue, administrator);
        this.administrator = administrator;
        this.fireOnPostWrite("administrator", oldValue, administrator);
    }

    @Override
    public boolean isAdministrator() {
        this.fireOnPreRead("administrator", this.administrator);
        boolean result = this.administrator;
        this.fireOnPostRead("administrator", this.administrator);
        return result;
    }

    @Override
    public void setLanguage(String language) {
        String oldValue = this.language;
        this.fireOnPreWrite("language", oldValue, language);
        this.language = language;
        this.fireOnPostWrite("language", oldValue, language);
    }

    @Override
    public String getLanguage() {
        this.fireOnPreRead("language", this.language);
        String result = this.language;
        this.fireOnPostRead("language", this.language);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        this.fireOnPreWrite("email", oldValue, email);
        this.email = email;
        this.fireOnPostWrite("email", oldValue, email);
    }

    @Override
    public String getEmail() {
        this.fireOnPreRead("email", this.email);
        String result = this.email;
        this.fireOnPostRead("email", this.email);
        return result;
    }

    @Override
    public void addFavoriteList(PersonList favoriteList) {
        this.fireOnPreWrite("favoriteList", null, favoriteList);
        if (this.favoriteList == null) {
            this.favoriteList = new ArrayList<PersonList>();
        }
        favoriteList.setOwner(this);
        this.favoriteList.add(favoriteList);
        this.fireOnPostWrite("favoriteList", this.favoriteList.size(), null, favoriteList);
    }

    @Override
    public void addAllFavoriteList(List<PersonList> favoriteList) {
        if (favoriteList == null) {
            return;
        }
        for (PersonList item : favoriteList) {
            this.addFavoriteList(item);
        }
    }

    @Override
    public void setFavoriteList(List<PersonList> favoriteList) {
        ArrayList<PersonList> oldValue = this.favoriteList != null ? new ArrayList<PersonList>(this.favoriteList) : null;
        this.fireOnPreWrite("favoriteList", oldValue, favoriteList);
        this.favoriteList = favoriteList;
        this.fireOnPostWrite("favoriteList", oldValue, favoriteList);
    }

    @Override
    public void removeFavoriteList(PersonList favoriteList) {
        this.fireOnPreWrite("favoriteList", favoriteList, null);
        if (this.favoriteList == null || !this.favoriteList.remove(favoriteList)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        favoriteList.setOwner(null);
        this.fireOnPostWrite("favoriteList", this.favoriteList.size() + 1, favoriteList, null);
    }

    @Override
    public void clearFavoriteList() {
        if (this.favoriteList == null) {
            return;
        }
        for (PersonList item : this.favoriteList) {
            item.setOwner(null);
        }
        ArrayList<PersonList> oldValue = new ArrayList<PersonList>(this.favoriteList);
        this.fireOnPreWrite("favoriteList", oldValue, this.favoriteList);
        this.favoriteList.clear();
        this.fireOnPostWrite("favoriteList", oldValue, this.favoriteList);
    }

    @Override
    public List<PersonList> getFavoriteList() {
        return this.favoriteList;
    }

    @Override
    public PersonList getFavoriteListByTopiaId(String topiaId) {
        return (PersonList)TopiaEntityHelper.getEntityByTopiaId(this.favoriteList, (String)topiaId);
    }

    @Override
    public int sizeFavoriteList() {
        if (this.favoriteList == null) {
            return 0;
        }
        return this.favoriteList.size();
    }

    @Override
    public boolean isFavoriteListEmpty() {
        int size = this.sizeFavoriteList();
        return size == 0;
    }

    @Override
    public void addPollAccount(PollAccount pollAccount) {
        this.fireOnPreWrite("pollAccount", null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }
        pollAccount.setUserAccount(this);
        this.pollAccount.add(pollAccount);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size(), null, pollAccount);
    }

    @Override
    public void addAllPollAccount(List<PollAccount> pollAccount) {
        if (pollAccount == null) {
            return;
        }
        for (PollAccount item : pollAccount) {
            this.addPollAccount(item);
        }
    }

    @Override
    public void setPollAccount(List<PollAccount> pollAccount) {
        ArrayList<PollAccount> oldValue = this.pollAccount != null ? new ArrayList<PollAccount>(this.pollAccount) : null;
        this.fireOnPreWrite("pollAccount", oldValue, pollAccount);
        this.pollAccount = pollAccount;
        this.fireOnPostWrite("pollAccount", oldValue, pollAccount);
    }

    @Override
    public void removePollAccount(PollAccount pollAccount) {
        this.fireOnPreWrite("pollAccount", pollAccount, null);
        if (this.pollAccount == null || !this.pollAccount.remove(pollAccount)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        pollAccount.setUserAccount(null);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size() + 1, pollAccount, null);
    }

    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setUserAccount(null);
        }
        ArrayList<PollAccount> oldValue = new ArrayList<PollAccount>(this.pollAccount);
        this.fireOnPreWrite("pollAccount", oldValue, this.pollAccount);
        this.pollAccount.clear();
        this.fireOnPostWrite("pollAccount", oldValue, this.pollAccount);
    }

    @Override
    public List<PollAccount> getPollAccount() {
        return this.pollAccount;
    }

    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return (PollAccount)TopiaEntityHelper.getEntityByTopiaId(this.pollAccount, (String)topiaId);
    }

    @Override
    public int sizePollAccount() {
        if (this.pollAccount == null) {
            return 0;
        }
        return this.pollAccount.size();
    }

    @Override
    public boolean isPollAccountEmpty() {
        int size = this.sizePollAccount();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }
}

