package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CommentAbstract extends TopiaEntityAbstract implements Comment {

    /**
     * Nom de l'attribut en BD : text
     */
    protected String text;

    /**
     * Nom de l'attribut en BD : postDate
     */
    protected Date postDate;

    /**
     * Nom de l'attribut en BD : author
     */
    protected String author;

    /**
     * Nom de l'attribut en BD : pollAccount
     */
    protected PollAccount pollAccount;

    private static final long serialVersionUID = 4120851251172815201L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_TEXT, String.class, text);
        visitor.visit(this, PROPERTY_POST_DATE, Date.class, postDate);
        visitor.visit(this, PROPERTY_AUTHOR, String.class, author);
        visitor.visit(this, PROPERTY_POLL_ACCOUNT, PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public void setText(String text) {
        String oldValue = this.text;
        fireOnPreWrite(PROPERTY_TEXT, oldValue, text);
        this.text = text;
        fireOnPostWrite(PROPERTY_TEXT, oldValue, text);
    }

    @Override
    public String getText() {
        fireOnPreRead(PROPERTY_TEXT, text);
        String result = this.text;
        fireOnPostRead(PROPERTY_TEXT, text);
        return result;
    }

    @Override
    public void setPostDate(Date postDate) {
        Date oldValue = this.postDate;
        fireOnPreWrite(PROPERTY_POST_DATE, oldValue, postDate);
        this.postDate = postDate;
        fireOnPostWrite(PROPERTY_POST_DATE, oldValue, postDate);
    }

    @Override
    public Date getPostDate() {
        fireOnPreRead(PROPERTY_POST_DATE, postDate);
        Date result = this.postDate;
        fireOnPostRead(PROPERTY_POST_DATE, postDate);
        return result;
    }

    @Override
    public void setAuthor(String author) {
        String oldValue = this.author;
        fireOnPreWrite(PROPERTY_AUTHOR, oldValue, author);
        this.author = author;
        fireOnPostWrite(PROPERTY_AUTHOR, oldValue, author);
    }

    @Override
    public String getAuthor() {
        fireOnPreRead(PROPERTY_AUTHOR, author);
        String result = this.author;
        fireOnPostRead(PROPERTY_AUTHOR, author);
        return result;
    }

    @Override
    public void setPollAccount(PollAccount pollAccount) {
        PollAccount oldValue = this.pollAccount;
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
        this.pollAccount = pollAccount;
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
    }

    @Override
    public PollAccount getPollAccount() {
        fireOnPreRead(PROPERTY_POLL_ACCOUNT, pollAccount);
        PollAccount result = this.pollAccount;
        fireOnPostRead(PROPERTY_POLL_ACCOUNT, pollAccount);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //CommentAbstract
