/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAOAbstract;
import org.chorem.pollen.business.persistence.Poll;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class CommentDAOImpl<E extends Comment>
extends CommentDAOAbstract<E> {
    public List<E> getComments(TopiaFilterPagerUtil.FilterPagerBean pager, String pollId) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)pollId);
        TopiaQuery countQuery = this.createQuery("e").addFrom(Poll.class, "p").addWhere("p.pollId", TopiaQuery.Op.EQ, (Object)pollId).addWhere("e in elements(p.comment)");
        long records = this.countByQuery(countQuery);
        pager.setRecords((int)records);
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)countQuery, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }

    public List<E> getAllComments(String pollId) throws TopiaException {
        Preconditions.checkNotNull((Object)pollId);
        TopiaQuery query = this.createQuery("e").addFrom(Poll.class, "p").addWhere("p.pollId", TopiaQuery.Op.EQ, (Object)pollId).addWhere("e in elements(p.comment)");
        query.addOrderDesc("postDate");
        List result = this.findAllByQuery(query);
        return result;
    }
}

