/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class VoteToChoiceAbstract extends TopiaEntityAbstract implements VoteToChoice {

    /**
     * Nom de l'attribut en BD : voteValue
     */
    protected Integer voteValue;

    /**
     * Nom de l'attribut en BD : vote
     */
    protected Vote vote;

    /**
     * Nom de l'attribut en BD : choice
     */
    protected Choice choice;

    private static final long serialVersionUID = 7149293105310753078L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_VOTE_VALUE, Integer.class, voteValue);
        visitor.visit(this, PROPERTY_VOTE, Vote.class, vote);
        visitor.visit(this, PROPERTY_CHOICE, Choice.class, choice);
        visitor.end(this);
    }

    @Override
    public void setVoteValue(Integer voteValue) {
        Integer oldValue = this.voteValue;
        fireOnPreWrite(PROPERTY_VOTE_VALUE, oldValue, voteValue);
        this.voteValue = voteValue;
        fireOnPostWrite(PROPERTY_VOTE_VALUE, oldValue, voteValue);
    }

    @Override
    public Integer getVoteValue() {
        fireOnPreRead(PROPERTY_VOTE_VALUE, voteValue);
        Integer result = this.voteValue;
        fireOnPostRead(PROPERTY_VOTE_VALUE, voteValue);
        return result;
    }

    @Override
    public void setVote(Vote vote) {
        Vote oldValue = this.vote;
        fireOnPreWrite(PROPERTY_VOTE, oldValue, vote);
        this.vote = vote;
        fireOnPostWrite(PROPERTY_VOTE, oldValue, vote);
    }

    @Override
    public Vote getVote() {
        fireOnPreRead(PROPERTY_VOTE, vote);
        Vote result = this.vote;
        fireOnPostRead(PROPERTY_VOTE, vote);
        return result;
    }

    @Override
    public void setChoice(Choice choice) {
        Choice oldValue = this.choice;
        fireOnPreWrite(PROPERTY_CHOICE, oldValue, choice);
        this.choice = choice;
        fireOnPostWrite(PROPERTY_CHOICE, oldValue, choice);
    }

    @Override
    public Choice getChoice() {
        fireOnPreRead(PROPERTY_CHOICE, choice);
        Choice result = this.choice;
        fireOnPostRead(PROPERTY_CHOICE, choice);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //VoteToChoiceAbstract
