/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.votecounting.dto.CommentDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.nuiton.topia.persistence.TopiaEntity;

public class PollenFunctions {
    public static final Function<TopiaEntity, String> ENTITY_BY_ID = new Function<TopiaEntity, String>(){

        public String apply(TopiaEntity input) {
            return input.getTopiaId();
        }
    };
    public static final Function<UserAccount, String> USER_BY_LOGIN = new Function<UserAccount, String>(){

        public String apply(UserAccount input) {
            return input.getLogin();
        }
    };
    public static final Function<Poll, PollDTO> POLL_TO_BEAN = new Function<Poll, PollDTO>(){

        public PollDTO apply(Poll input) {
            PollDTO result = new PollDTO(input.getPollId());
            result.setTitle(input.getTitle());
            result.setDescription(input.getDescription());
            result.setBeginChoiceDate(input.getBeginChoiceDate());
            result.setBeginDate(input.getBeginDate());
            result.setEndDate(input.getEndDate());
            result.setAnonymous(input.isAnonymous());
            result.setAnonymousVoteAllowed(input.isAnonymousVoteAllowed());
            result.setPublicResults(input.isPublicResults());
            result.setContinuousResults(input.isContinuousResults());
            result.setChoiceAddAllowed(input.isChoiceAddAllowed());
            result.setClosed(input.isClosed());
            result.setCreatorId(input.getCreator().getVotingId());
            result.setCreatorEmail(input.getCreator().getEmail());
            result.setMaxChoiceNb(input.getMaxChoiceNb());
            result.setPollType(input.getPollType());
            result.setChoiceType(input.getChoiceType());
            result.setVoteCounting(input.getVoteCountingType());
            result.setComments(Lists.transform(input.getComment(), COMMENT_TO_BEAN));
            result.setChoices(Lists.transform(input.getChoice(), CHOICE_TO_BEAN));
            if (!input.isVotingListEmpty()) {
                result.setVotingGroups(Lists.transform(input.getVotingList(), PollenFunctions.newVotingListToBean(input)));
            } else {
                VotingGroupDTO group = new VotingGroupDTO("unique", 1.0);
                group.setName("unique");
                List votes = Lists.transform(input.getVote(), VOTE_TO_BEAN);
                group.setVotingPersons(votes);
                result.getVotingGroups().add(group);
            }
            return result;
        }
    };
    public static final Function<Comment, CommentDTO> COMMENT_TO_BEAN = new Function<Comment, CommentDTO>(){

        public CommentDTO apply(Comment input) {
            CommentDTO result = new CommentDTO(input.getAuthor(), input.getText());
            return result;
        }
    };
    public static final Function<Choice, PollChoiceDTO> CHOICE_TO_BEAN = new Function<Choice, PollChoiceDTO>(){

        public PollChoiceDTO apply(Choice input) {
            PollChoiceDTO result = new PollChoiceDTO(input.getTopiaId());
            String choiceName = input.getName();
            result.setName(choiceName);
            result.setHidden(choiceName != null && choiceName.startsWith("HIDDEN_"));
            result.setDescription(input.getDescription());
            return result;
        }
    };
    public static final Function<Vote, VotingPersonDTO> VOTE_TO_BEAN = new Function<Vote, VotingPersonDTO>(){

        public VotingPersonDTO apply(Vote input) {
            VotingPersonDTO result = new VotingPersonDTO(input.getPollAccount().getVotingId(), input.getWeight());
            result.setEmail(input.getPollAccount().getEmail());
            if (!input.isChoiceVoteToChoiceEmpty()) {
                for (VoteToChoice vToChoice : input.getChoiceVoteToChoice()) {
                    if (vToChoice == null || vToChoice.getChoice() == null) continue;
                    VoteToChoiceDTO bean = (VoteToChoiceDTO)VOTE_TO_CHOICE_TO_BEAN.apply((Object)vToChoice);
                    result.getChoices().add(bean);
                }
            }
            return result;
        }
    };
    public static final Function<VoteToChoice, VoteToChoiceDTO> VOTE_TO_CHOICE_TO_BEAN = new Function<VoteToChoice, VoteToChoiceDTO>(){

        public VoteToChoiceDTO apply(VoteToChoice input) {
            VoteToChoiceDTO result = new VoteToChoiceDTO(input.getChoice().getTopiaId(), (double)input.getVoteValue().intValue());
            return result;
        }
    };
    public static final Function<Map.Entry<Poll, PollAccount>, Pair<Poll, PollAccount>> MAP_ENTRY_TO_PAIR_FUNCTION = new Function<Map.Entry<Poll, PollAccount>, Pair<Poll, PollAccount>>(){

        public Pair<Poll, PollAccount> apply(Map.Entry<Poll, PollAccount> input) {
            return Pair.of((Object)input.getKey(), (Object)input.getValue());
        }
    };

    public static Function<VotingList, VotingGroupDTO> newVotingListToBean(final Poll poll) {
        return new Function<VotingList, VotingGroupDTO>(){

            public VotingGroupDTO apply(VotingList input) {
                VotingGroupDTO result = new VotingGroupDTO(input.getTopiaId(), input.getWeight());
                result.setName(input.getName());
                for (PersonToList pToList : input.getPollAccountPersonToList()) {
                    Vote vote = poll.getVoteByPollAccount(pToList.getPollAccount());
                    if (vote == null) continue;
                    VotingPersonDTO bean = (VotingPersonDTO)VOTE_TO_BEAN.apply((Object)vote);
                    result.getVotingPersons().add(bean);
                }
                return result;
            }
        };
    }
}

