package org.chorem.pollen.business.persistence;

import java.util.Date;
import java.util.List;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Poll extends TopiaEntity {

    String PROPERTY_POLL_ID = "pollId";

    String PROPERTY_TITLE = "title";

    String PROPERTY_DESCRIPTION = "description";

    String PROPERTY_BEGIN_CHOICE_DATE = "beginChoiceDate";

    String PROPERTY_BEGIN_DATE = "beginDate";

    String PROPERTY_END_DATE = "endDate";

    String PROPERTY_MAX_CHOICE_NB = "maxChoiceNb";

    String PROPERTY_CLOSED = "closed";

    String PROPERTY_CHOICE_ADD_ALLOWED = "choiceAddAllowed";

    String PROPERTY_ANONYMOUS_VOTE_ALLOWED = "anonymousVoteAllowed";

    String PROPERTY_PUBLIC_RESULTS = "publicResults";

    String PROPERTY_CONTINUOUS_RESULTS = "continuousResults";

    String PROPERTY_END_CHOICE_DATE = "endChoiceDate";

    String PROPERTY_RESULT_UPTODATE = "resultUptodate";

    String PROPERTY_VOTE_COUNTING_TYPE = "voteCountingType";

    String PROPERTY_VOTE = "vote";

    String PROPERTY_CHOICE = "choice";

    String PROPERTY_RESULT = "result";

    String PROPERTY_CREATOR = "creator";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_PREVENT_RULE = "preventRule";

    String PROPERTY_VOTING_LIST = "votingList";

    String PROPERTY_POLL_TYPE = "pollType";

    String PROPERTY_CHOICE_TYPE = "choiceType";

    String PROPERTY_POLL_VOTE_VISIBILITY = "pollVoteVisibility";

    String PROPERTY_POLL_COMMENT_VISIBILITY = "pollCommentVisibility";

    void setPollId(String pollId);

    String getPollId();

    void setTitle(String title);

    String getTitle();

    void setDescription(String description);

    String getDescription();

    void setBeginChoiceDate(Date beginChoiceDate);

    Date getBeginChoiceDate();

    void setBeginDate(Date beginDate);

    Date getBeginDate();

    void setEndDate(Date endDate);

    Date getEndDate();

    void setMaxChoiceNb(int maxChoiceNb);

    int getMaxChoiceNb();

    void setClosed(boolean closed);

    boolean isClosed();

    void setChoiceAddAllowed(boolean choiceAddAllowed);

    boolean isChoiceAddAllowed();

    void setAnonymousVoteAllowed(boolean anonymousVoteAllowed);

    boolean isAnonymousVoteAllowed();

    void setPublicResults(boolean publicResults);

    boolean isPublicResults();

    void setContinuousResults(boolean continuousResults);

    boolean isContinuousResults();

    void setEndChoiceDate(Date endChoiceDate);

    Date getEndChoiceDate();

    void setResultUptodate(boolean resultUptodate);

    boolean isResultUptodate();

    void setVoteCountingType(int voteCountingType);

    int getVoteCountingType();

    void addVote(Vote vote);

    void addAllVote(List<Vote> vote);

    void setVote(List<Vote> vote);

    void removeVote(Vote vote);

    void clearVote();

    List<Vote> getVote();

    Vote getVoteByTopiaId(String topiaId);

    int sizeVote();

    boolean isVoteEmpty();

    void addChoice(Choice choice);

    void addAllChoice(List<Choice> choice);

    void setChoice(List<Choice> choice);

    void removeChoice(Choice choice);

    void clearChoice();

    List<Choice> getChoice();

    Choice getChoiceByTopiaId(String topiaId);

    int sizeChoice();

    boolean isChoiceEmpty();

    void addResult(Result result);

    void addAllResult(List<Result> result);

    void setResult(List<Result> result);

    void removeResult(Result result);

    void clearResult();

    List<Result> getResult();

    Result getResultByTopiaId(String topiaId);

    int sizeResult();

    boolean isResultEmpty();

    void setCreator(PollAccount creator);

    PollAccount getCreator();

    void addComment(Comment comment);

    void addAllComment(List<Comment> comment);

    void setComment(List<Comment> comment);

    void removeComment(Comment comment);

    void clearComment();

    List<Comment> getComment();

    Comment getCommentByTopiaId(String topiaId);

    int sizeComment();

    boolean isCommentEmpty();

    void addPreventRule(PreventRule preventRule);

    void addAllPreventRule(List<PreventRule> preventRule);

    void setPreventRule(List<PreventRule> preventRule);

    void removePreventRule(PreventRule preventRule);

    void clearPreventRule();

    List<PreventRule> getPreventRule();

    PreventRule getPreventRuleByTopiaId(String topiaId);

    int sizePreventRule();

    boolean isPreventRuleEmpty();

    void addVotingList(VotingList votingList);

    void addAllVotingList(List<VotingList> votingList);

    void setVotingList(List<VotingList> votingList);

    void removeVotingList(VotingList votingList);

    void clearVotingList();

    List<VotingList> getVotingList();

    VotingList getVotingListByTopiaId(String topiaId);

    int sizeVotingList();

    boolean isVotingListEmpty();

    void setPollType(PollType pollType);

    PollType getPollType();

    void setChoiceType(ChoiceType choiceType);

    ChoiceType getChoiceType();

    void setPollVoteVisibility(PollVoteVisibility pollVoteVisibility);

    PollVoteVisibility getPollVoteVisibility();

    void setPollCommentVisibility(PollCommentVisibility pollCommentVisibility);

    PollCommentVisibility getPollCommentVisibility();

    Vote getVoteByPollAccount(PollAccount account);

    String getAdminId();

    String getVoteId(PollAccount account);

    boolean isStarted(Date currentDate);

    boolean isRunning(Date currentDate);

    boolean isFinished(Date currentDate);

    boolean isAddChoiceStarted(Date currentDate);

    boolean isAddChoiceRunning(Date currentDate);

    boolean isAddChoiceFinished(Date currentDate);

    List<PollAccount> getPollAccounts(boolean withNoVote);

    PersonToList getPersonToListByVote(Vote vote);

    PreventRule getPreventRuleByScope(String scope);

    boolean isAnonymous();

    boolean isPollFree();

} //Poll
