/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PollDAOImpl<E extends Poll>
extends PollDAOAbstract<E> {
    private static final Log log = LogFactory.getLog(PollDAOImpl.class);

    public List<E> getPolls(TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        long records = this.count();
        pager.setRecords((int)records);
        TopiaQuery query = this.createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)query, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }

    public List<E> getCreatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        TopiaQuery countQuery = this.createQuery("e");
        countQuery.addWhere("e.creator.userAccount", TopiaQuery.Op.EQ, (Object)user);
        long records = this.countByQuery(countQuery);
        pager.setRecords((int)records);
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)countQuery, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }

    public Map<Poll, PollAccount> getInvitedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount userToUse) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)userToUse);
        String email = userToUse.getEmail();
        TopiaQuery countQuery = this.createQuery("p");
        countQuery.addLeftJoin("p.votingList", "v", false);
        countQuery.addLeftJoin("v.pollAccountPersonToList", "l", false);
        countQuery.addEquals("l.pollAccount.email", new Object[]{email});
        long records = this.countByQuery(countQuery);
        pager.setRecords((int)records);
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)countQuery, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        return this.findAllWithPollAccounts(query, "p", "l.pollAccount");
    }

    public Map<Poll, PollAccount> getParticipatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount userToUse) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)userToUse);
        VoteDAO voteDao = PollenDAOHelper.getVoteDAO((TopiaContext)this.context);
        TopiaQuery countQuery = voteDao.createQuery("e").addDistinct().setSelect(new String[]{"e.poll"}).addWhere("e.pollAccount.userAccount", TopiaQuery.Op.EQ, (Object)userToUse);
        long records = this.countByQuery(countQuery);
        pager.setRecords((int)records);
        TopiaQuery query = TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)countQuery, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        return this.findAllWithPollAccounts(query, "e.poll", "e.pollAccount");
    }

    protected Map<Poll, PollAccount> findAllWithPollAccounts(TopiaQuery query, String pollAlias, String pollAccountAlias) throws TopiaException {
        query.setSelect(new String[]{pollAlias, pollAccountAlias});
        List queryResults = this.getContext().findByQuery(query);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object[] row : queryResults) {
            Poll poll = (Poll)row[0];
            PollAccount pollAccount = (PollAccount)row[1];
            result.put(poll, pollAccount);
        }
        return result;
    }

    public List<E> getRunningPolls(boolean withEndDate) throws TopiaException {
        TopiaQuery query = withEndDate ? this.createQuery("poll").addWhere("poll.endDate is not null and poll.endDate > current_timestamp()").addWhere("poll.beginDate is null or poll.beginDate < current_timestamp()") : this.createQuery("poll").addWhere("poll.endDate is null or poll.endDate > current_timestamp()").addWhere("poll.beginDate is null or poll.beginDate < current_timestamp()");
        List results = this.findAllByQuery(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
        }
        return results;
    }
}

