/*
 * #%L
 * Pollen :: Persistence
 * 
 * $Id: PollenMigrationCallback.java 3402 2012-05-28 16:50:10Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-persistence/src/main/java/org/chorem/pollen/entities/migration/PollenMigrationCallback.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.entities.migration;

import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import java.util.List;

/**
 * Pollen Migration callback.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenMigrationCallback extends TopiaMigrationCallbackByClass {

    public static final Version V_1_1 = VersionUtil.valueOf("1.1");

    public static final Version V_1_2 = VersionUtil.valueOf("1.2");

    public static final Version V_1_3 = VersionUtil.valueOf("1.3");

    public static final Version V_1_3_1 = VersionUtil.valueOf("1.3.1");

    /** Les versions de mise à jour disponibles. */
    public static final Version[] AVAILABLE_VERSIONS = new Version[]{
            V_1_1, V_1_2, V_1_3, V_1_3_1
    };

    public PollenMigrationCallback() {
        super(new PollenMigrationCallBackForVersionResolver());
    }

    @Override
    public Version[] getAvailableVersions() {
        return AVAILABLE_VERSIONS;
    }

    @Override
    public Version getApplicationVersion() {
        return VersionUtil.valueOf(PollenDAOHelper.getModelVersion());
    }

    @Override
    public boolean askUser(Version version, List<Version> versions) {
        return true;
    }

    /**
     * Migration resolver for each version.
     *
     * @author tchemit <chemit@codelutin.com>
     * @since 1.0.1
     */
    public static class PollenMigrationCallBackForVersionResolver implements MigrationCallBackForVersionResolver {

        @Override
        public Class<? extends MigrationCallBackForVersion> getCallBack(Version version) {

            String fqn = PollenMigrationCallback.class.getName() + "V" + version.getValidName();
            Class<?> klass;
            try {
                klass = Class.forName(fqn);
            } catch (ClassNotFoundException e) {
                throw new IllegalStateException(
                        "Could not find migration class " + fqn, e);
            }
            return (Class<? extends MigrationCallBackForVersion>) klass;
        }
    }
}
