/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public interface PollAccount extends TopiaEntity {

    String PROPERTY_ACCOUNT_ID = "accountId";

    String PROPERTY_VOTING_ID = "votingId";

    String PROPERTY_EMAIL = "email";

    String PROPERTY_VOTING_LIST_PERSON_TO_LIST = "votingListPersonToList";

    String PROPERTY_POLLS_CREATED = "pollsCreated";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_VOTE = "vote";

    String PROPERTY_PERSON_LIST = "personList";

    String PROPERTY_USER_ACCOUNT = "userAccount";

    void setAccountId(String accountId);

    String getAccountId();

    void setVotingId(String votingId);

    String getVotingId();

    void setEmail(String email);

    String getEmail();

    void addVotingListPersonToList(PersonToList votingListPersonToList);

    void addAllVotingListPersonToList(List<PersonToList> votingListPersonToList);

    void setVotingListPersonToList(List<PersonToList> votingListPersonToList);

    void removeVotingListPersonToList(PersonToList votingListPersonToList);

    void clearVotingListPersonToList();

    List<PersonToList> getVotingListPersonToList();

    PersonToList getVotingListPersonToListByTopiaId(String topiaId);

    PersonToList getVotingListPersonToList(VotingList votingList);

    int sizeVotingListPersonToList();

    boolean isVotingListPersonToListEmpty();

    void addPollsCreated(Poll pollsCreated);

    void addAllPollsCreated(List<Poll> pollsCreated);

    void setPollsCreated(List<Poll> pollsCreated);

    void removePollsCreated(Poll pollsCreated);

    void clearPollsCreated();

    List<Poll> getPollsCreated();

    Poll getPollsCreatedByTopiaId(String topiaId);

    int sizePollsCreated();

    boolean isPollsCreatedEmpty();

    void addComment(Comment comment);

    void addAllComment(List<Comment> comment);

    void setComment(List<Comment> comment);

    void removeComment(Comment comment);

    void clearComment();

    List<Comment> getComment();

    Comment getCommentByTopiaId(String topiaId);

    int sizeComment();

    boolean isCommentEmpty();

    void addVote(Vote vote);

    void addAllVote(List<Vote> vote);

    void setVote(List<Vote> vote);

    void removeVote(Vote vote);

    void clearVote();

    List<Vote> getVote();

    Vote getVoteByTopiaId(String topiaId);

    int sizeVote();

    boolean isVoteEmpty();

    void setPersonList(PersonList personList);

    PersonList getPersonList();

    void setUserAccount(UserAccount userAccount);

    UserAccount getUserAccount();

} //PollAccount
