/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.UserDTO;

/**
 * Interface du service de gestion des utilisateurs.
 *
 * @author amine
 * @version $Id: ServiceUser.java 2737 2009-08-20 13:00:52Z nrannou $
 */
public interface ServiceUser {

    /**
     * Création des utilisateurs
     *
     * @param user l'utilisateur
     * @param password le mot de passe
     * @return l'identifiant de l'utilisateur créé
     */
    public String createUser(UserDTO user, String password);

    /**
     * Modification d'un utilistaeur
     *
     * @param user utilisateur
     * @return true si l'utilisateur a été modifié
     */
    public boolean updateUser(UserDTO user);

    /**
     * Suppression d'un utilisateur
     *
     * @param login de l'utilisateur à supprimer
     * @return true si l'utilisateur a été supprimé
     */
    public boolean deleteUser(String login);

    /**
     * Suppression d'un utilisateur
     *
     * @param user un utilisateur
     * @return true si l'utilisateur a été supprimé
     */
    public boolean deleteUser(UserDTO user);

    /**
     * Récupération d'un utilisateur à partir de son identifiant
     *
     * @param userId identifiant de l'utilisateur
     * @return l'utilisateur
     */
    public UserDTO findUserById(String userId);

    /**
     * Récupération des utilisateurs
     *
     * @param properties filtre
     * @return liste d'utilisateurs
     */
    public List<UserDTO> selectUsers(Map<String, Object> properties);

    /**
     * Mise à jour du mot de passe d'un utilisateur
     *
     * @param user l'utilisateur
     * @param newPassword le nouveau mot de passe
     * @return true si le mot de passe a été modifié
     */
    public boolean updatePasswordUser(UserDTO user, String newPassword);

    /**
     * Test de l'existance d'un identifiant utilisateur
     *
     * @param login l'identifiant utilisateur
     * @return true si l'identifiant existe, false sinon
     */
    public boolean isUserLoginExisting(String login);

    /**
     * Test de l'existance d'un email utilisateur
     *
     * @param email l'email utilisateur
     * @return true si l'email existe, false sinon
     */
    public boolean isUserEmailExisting(String email);
}