/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.DataPollAccountConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.nuiton.topia.TopiaException;

public class DataVotingListConverter
extends DataConverter {
    public void populateVotingListEntity(VotingListDTO votingListDTO, VotingList eVotingList) throws TopiaException {
        eVotingList.setName(votingListDTO.getName());
        eVotingList.setWeight(votingListDTO.getWeight());
        if (votingListDTO.getPollId() != null && votingListDTO.getPollId().length() > 0) {
            PollDAO pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)pollDAO.findByTopiaId(votingListDTO.getPollId());
            eVotingList.setPoll(pollEntity);
        }
        if (votingListDTO.getVoteId() != null && votingListDTO.getVoteId().length() > 0) {
            VoteDAO voteDAO = PollenModelDAOHelper.getVoteDAO(this.transaction);
            Vote voteEntity = (Vote)voteDAO.findByTopiaId(votingListDTO.getVoteId());
            eVotingList.setVote(voteEntity);
        }
    }

    public VotingListDTO createVotingListDTO(VotingList eVotingList) {
        VotingListDTO dto = new VotingListDTO();
        dto.setId(eVotingList.getTopiaId());
        dto.setName(eVotingList.getName());
        dto.setWeight(eVotingList.getWeight());
        dto.setPollAccountDTOs(this.getPollAccountDTOs(eVotingList.getPollAccountPersonToList()));
        if (eVotingList.getPoll() != null) {
            dto.setPollId(eVotingList.getPoll().getTopiaId());
        }
        if (eVotingList.getVote() != null) {
            dto.setVoteId(eVotingList.getVote().getTopiaId());
        }
        return dto;
    }

    public List<VotingListDTO> createVotingListDTOs(List<VotingList> lVotingLists) {
        ArrayList<VotingListDTO> results = new ArrayList<VotingListDTO>();
        for (VotingList v : lVotingLists) {
            VotingListDTO dto = this.createVotingListDTO(v);
            results.add(dto);
        }
        return results;
    }

    private List<PollAccountDTO> getPollAccountDTOs(Collection<PersonToList> persons) {
        ArrayList<PollAccountDTO> accounts = new ArrayList<PollAccountDTO>();
        DataPollAccountConverter converter = new DataPollAccountConverter();
        for (PersonToList p : persons) {
            accounts.add(converter.createPollAccountDTO(p.getPollAccount()));
        }
        return accounts;
    }

    public void populatePersonVotingList(VotingListDTO votingListDTO, VotingList eVotingList) throws TopiaException {
        for (PollAccountDTO pollAccountDTO : votingListDTO.getPollAccountDTOs()) {
            pollAccountDTO.setVotingListId(eVotingList.getTopiaId());
        }
        eVotingList.setPollAccountPersonToList(this.getPersonToLists(votingListDTO.getPollAccountDTOs()));
    }

    private List<PersonToList> getPersonToLists(List<PollAccountDTO> pollAccountDTOs) throws TopiaException {
        ArrayList<PersonToList> liste = new ArrayList<PersonToList>();
        for (PollAccountDTO pollAccountDTO : pollAccountDTOs) {
            PersonToListDAO personToListDAO = PollenModelDAOHelper.getPersonToListDAO(this.transaction);
            PersonToList personToListEntity = (PersonToList)personToListDAO.create(new Object[0]);
            personToListEntity.setWeight(pollAccountDTO.getWeight());
            personToListEntity.setHasVoted(pollAccountDTO.isHasVoted());
            VotingListDAO votingListDAO = PollenModelDAOHelper.getVotingListDAO(this.transaction);
            VotingList votingListEntity = (VotingList)votingListDAO.findByTopiaId(pollAccountDTO.getVotingListId());
            personToListEntity.setVotingList(votingListEntity);
            PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)pollAccountDAO.findByTopiaId(pollAccountDTO.getId());
            personToListEntity.setPollAccount(pollAccountEntity);
            liste.add(personToListEntity);
        }
        return liste;
    }
}

