/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.DataPollAccountConverter;
import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.nuiton.topia.TopiaException;

public class DataPersonListConverter
extends DataConverter {
    public void populatePersonListEntity(PersonListDTO personListDTO, PersonList ePersonList) throws TopiaException {
        ePersonList.setName(personListDTO.getName());
        if (personListDTO.getUserId().length() > 0) {
            UserAccountDAO userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userAccountEntity = (UserAccount)userDAO.findByTopiaId(personListDTO.getUserId());
            ePersonList.setOwner(userAccountEntity);
        }
    }

    public PersonListDTO createPersonListDTO(PersonList ePersonList) {
        PersonListDTO personListDTO = new PersonListDTO();
        personListDTO.setId(ePersonList.getTopiaId());
        personListDTO.setName(ePersonList.getName());
        if (ePersonList.getOwner() != null) {
            personListDTO.setUserId(ePersonList.getOwner().getTopiaId());
        }
        if (ePersonList.getPollAccount().size() > 0) {
            DataPollAccountConverter converter = new DataPollAccountConverter();
            personListDTO.setPollAccountDTOs(converter.createPollAccountDTOs(ePersonList.getPollAccount()));
        }
        return personListDTO;
    }

    public List<PersonListDTO> createPersonListDTOs(List<PersonList> lPersonLists) {
        ArrayList<PersonListDTO> results = new ArrayList<PersonListDTO>();
        for (PersonList l : lPersonLists) {
            PersonListDTO dto = this.createPersonListDTO(l);
            results.add(dto);
        }
        return results;
    }
}

