/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"accountId","votingId","email"}
)        
public interface PollAccount extends TopiaEntity {

    public static final String ACCOUNT_ID = "accountId";

    public static final String VOTING_ID = "votingId";

    public static final String EMAIL = "email";

    public static final String VOTING_LIST_PERSON_TO_LIST = "votingListPersonToList";

    public static final String POLLS_CREATED = "pollsCreated";

    public static final String COMMENT = "comment";

    public static final String VOTE = "vote";

    public static final String PERSON_LIST = "personList";

    public static final String USER_ACCOUNT = "userAccount";

    /**
     * @param accountId La valeur de l'attribut accountId à positionner.
     */
    public void setAccountId(java.lang.String accountId);

    /**
     * @return La valeur de l'attribut accountId.
     */
    public java.lang.String getAccountId();

    /**
     * @param votingId La valeur de l'attribut votingId à positionner.
     */
    public void setVotingId(java.lang.String votingId);

    /**
     * @return La valeur de l'attribut votingId.
     */
    public java.lang.String getVotingId();

    /**
     * @param email La valeur de l'attribut email à positionner.
     */
    public void setEmail(java.lang.String email);

    /**
     * @return La valeur de l'attribut email.
     */
    public java.lang.String getEmail();

    /**
     * @param personToList L'instance de PersonToList à ajouter.
     */
    public void addVotingListPersonToList(org.chorem.pollen.business.persistence.PersonToList personToList);

    /**
     * @param personToList Les instances de PersonToList à ajouter.
     */
    public void addAllVotingListPersonToList(java.util.List<org.chorem.pollen.business.persistence.PersonToList> personToList);

    /**
     * @param personToList La Collection de PersonToList à positionner.
     */
    public void setVotingListPersonToList(java.util.List<org.chorem.pollen.business.persistence.PersonToList> personToList);

    /**
     * @param personToList L'instance de PersonToList à retirer.
     */
    public void removeVotingListPersonToList(org.chorem.pollen.business.persistence.PersonToList personToList);

    /**
     * Vide la Collection de PersonToList.
     */
    public void clearVotingListPersonToList();

    /**
     * @return La liste des attributs PersonToList.
     */
    public java.util.List<org.chorem.pollen.business.persistence.PersonToList> getVotingListPersonToList();

    /**
     * Recupère l'attribut votingList à partir de son topiaId.
     *
     * @param topiaId le topia id de l'attribut recherchée
     * 
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.PersonToList getVotingListPersonToListByTopiaId(String topiaId);

    /**
     * @return L'attribut PersonToList associé à la valeur <code>value</code> de l'attribut votingList.
     */
    public org.chorem.pollen.business.persistence.PersonToList getVotingListPersonToList(org.chorem.pollen.business.persistence.VotingList value);

    /**
     * @return Le nombre d'éléments de la collection votingList.
     */
    public int sizeVotingListPersonToList();
  
    /**
     * @return <code>true</code> si la collection votingListPersonToList est vide.
     */
    public boolean isVotingListPersonToListEmpty();
    /**
     * @param pollsCreated L'instance de pollsCreated à ajouter.
     */
    public void addPollsCreated(org.chorem.pollen.business.persistence.Poll pollsCreated);

    /**
     * @param pollsCreated Les instances de pollsCreated à ajouter.
     */
    public void addAllPollsCreated(java.util.List<org.chorem.pollen.business.persistence.Poll> pollsCreated);

    /**
     * @param pollsCreated La Collection de pollsCreated à positionner.
     */
    public void setPollsCreated(java.util.List<org.chorem.pollen.business.persistence.Poll> pollsCreated);

    /**
     * @param pollsCreated L'instance de pollsCreated à retirer.
     */
    public void removePollsCreated(org.chorem.pollen.business.persistence.Poll pollsCreated);

    /**
     * Vide la Collection de pollsCreated.
     */
    public void clearPollsCreated();

    /**
     * @return La Liste de pollsCreated.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Poll> getPollsCreated();


    /**
     * Recupère l'attribut pollsCreated à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Poll getPollsCreatedByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection pollsCreated.
     */
    public int sizePollsCreated();

    /**
     * @return <code>true</code> si la collection pollsCreated est vide.
     */
    public boolean isPollsCreatedEmpty();

    /**
     * @param comment L'instance de comment à ajouter.
     */
    public void addComment(org.chorem.pollen.business.persistence.Comment comment);

    /**
     * @param comment Les instances de comment à ajouter.
     */
    public void addAllComment(java.util.List<org.chorem.pollen.business.persistence.Comment> comment);

    /**
     * @param comment La Collection de comment à positionner.
     */
    public void setComment(java.util.List<org.chorem.pollen.business.persistence.Comment> comment);

    /**
     * @param comment L'instance de comment à retirer.
     */
    public void removeComment(org.chorem.pollen.business.persistence.Comment comment);

    /**
     * Vide la Collection de comment.
     */
    public void clearComment();

    /**
     * @return La Liste de comment.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Comment> getComment();


    /**
     * Recupère l'attribut comment à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Comment getCommentByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection comment.
     */
    public int sizeComment();

    /**
     * @return <code>true</code> si la collection comment est vide.
     */
    public boolean isCommentEmpty();

    /**
     * @param vote L'instance de vote à ajouter.
     */
    public void addVote(org.chorem.pollen.business.persistence.Vote vote);

    /**
     * @param vote Les instances de vote à ajouter.
     */
    public void addAllVote(java.util.List<org.chorem.pollen.business.persistence.Vote> vote);

    /**
     * @param vote La Collection de vote à positionner.
     */
    public void setVote(java.util.List<org.chorem.pollen.business.persistence.Vote> vote);

    /**
     * @param vote L'instance de vote à retirer.
     */
    public void removeVote(org.chorem.pollen.business.persistence.Vote vote);

    /**
     * Vide la Collection de vote.
     */
    public void clearVote();

    /**
     * @return La Liste de vote.
     */
    public java.util.List<org.chorem.pollen.business.persistence.Vote> getVote();


    /**
     * Recupère l'attribut vote à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.Vote getVoteByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection vote.
     */
    public int sizeVote();

    /**
     * @return <code>true</code> si la collection vote est vide.
     */
    public boolean isVoteEmpty();

    /**
     * @param personList La valeur de l'attribut personList à positionner.
     */
    public void setPersonList(org.chorem.pollen.business.persistence.PersonList personList);

    /**
     * @return La valeur de l'attribut personList.
     */
    public org.chorem.pollen.business.persistence.PersonList getPersonList();

    /**
     * @param userAccount La valeur de l'attribut userAccount à positionner.
     */
    public void setUserAccount(org.chorem.pollen.business.persistence.UserAccount userAccount);

    /**
     * @return La valeur de l'attribut userAccount.
     */
    public org.chorem.pollen.business.persistence.UserAccount getUserAccount();

} //PollAccount
