/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.ResultDAO;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * Gestion de la conversion des dtos en entité pour les résultats.
 *
 * @author fdesbois
 * @version $Id: DataResultConverter.java 2836 2010-01-11 12:46:59Z schorlet $
 */
public class DataResultConverter extends DataConverter {

    public DataResultConverter(TopiaContext transaction) {
        super(transaction);
    }

    /**
     * Création des résultats de sondage à partir d'un dto de résultats de
     * sondage.
     *
     * @param dto le dto des résultats de sondage.
     */
    public void populateResultEntities(VoteCountingResultDTO dto)
            throws TopiaException {
        for (ChoiceDTO choice : dto.getChoices()) {
            //if (choice.isResult) {
            ResultDAO daoResult = PollenModelDAOHelper.getResultDAO(transaction);
            Result eResult = daoResult.create();

            ChoiceDAO daoChoice = PollenModelDAOHelper.getChoiceDAO(transaction);
            Choice eChoice = daoChoice.findByTopiaId(choice.getIdChoice());

            PollDAO daoPoll = PollenModelDAOHelper.getPollDAO(transaction);
            Poll ePoll = daoPoll.findByPollId(dto.getIdPoll());
            ePoll.addResult(eResult);

            eResult.setName(eChoice.getName());
            eResult.setByGroup(dto.isByGroup());
            eResult.setPoll(ePoll);
            eResult.setResultValue(String.valueOf(choice.getValue()));
            
            EnumController enumCtrl = new EnumController(transaction);
            enumCtrl.setVoteCounting(dto.getTypeVoteCounting(), eResult);
            //}
        }
    }

    /**
     * Retourne la liste des résultats d'un sondage sous forme de DTOs.
     *
     * @param ePoll le sondage (entitée Poll)
     * @return la liste des DTO Result
     */
    public List<ResultDTO> createResultDTOs(Poll ePoll) {
        List<ResultDTO> results = new ArrayList<ResultDTO>();
        for (Result res : ePoll.getResult()) {
            ResultDTO dto = new ResultDTO();
            dto.setId(res.getTopiaId());
            dto.setPollId(ePoll.getPollId());
            dto.setName(res.getName());
            dto.setValue(res.getResultValue());
            dto.setByGroup(res.getByGroup());
            dto.setChoiceType(EnumController.getChoiceType(ePoll));
            dto.setVoteCounting(EnumController.getVoteCountingType(ePoll));
            results.add(dto);
        }
        return results;
    }

}
