/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataPollAccountConverter;
import org.chorem.pollen.business.converters.DataVoteConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.VoteDTO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.services.ServiceVote;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceVoteImpl
implements ServiceVote {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private VoteDAO voteDAO = null;
    private DataVoteConverter converter = new DataVoteConverter();
    private static final Log log = LogFactory.getLog(ServiceVoteImpl.class);

    @Override
    public String createVote(VoteDTO voteDTO, PollAccountDTO pollAccountDTO) {
        TopiaContext transaction = null;
        String topiaId = null;
        try {
            transaction = this.rootContext.beginTransaction();
            if (pollAccountDTO != null) {
                pollAccountDTO.setHasVoted(true);
                PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
                PollAccount pollAccountEntity = (PollAccount)pollAccountDAO.findByTopiaId(pollAccountDTO.getId());
                if (pollAccountEntity == null) {
                    log.debug((Object)"Nouveau compte associ\u00e9 au vote");
                    pollAccountEntity = (PollAccount)pollAccountDAO.create(new Object[0]);
                } else {
                    log.debug((Object)("Compte associ\u00e9 au vote : " + pollAccountEntity.getTopiaId()));
                }
                DataPollAccountConverter pollAccountConverter = new DataPollAccountConverter();
                pollAccountConverter.setTransaction(transaction);
                pollAccountConverter.populatePollAccountEntity(pollAccountDTO, pollAccountEntity);
                pollAccountDAO.update(pollAccountEntity);
                voteDTO.setPollAccountId(pollAccountEntity.getTopiaId());
                voteDTO.setVotingListId(pollAccountDTO.getVotingListId());
                voteDTO.setWeight(pollAccountDTO.getWeight());
                log.debug((Object)("Poids du vote : " + voteDTO.getWeight()));
            } else {
                voteDTO.setPollAccountId(null);
            }
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)this.voteDAO.create(new Object[0]);
            this.converter.setTransaction(transaction);
            this.converter.populateVoteEntity(voteDTO, voteEntity);
            transaction.commitTransaction();
            this.converter.populateChoiceVote(voteDTO, voteEntity);
            topiaId = voteEntity.getTopiaId();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (Exception eee) {
            ContextUtil.doCatch(eee, transaction, "Problem when creating vote with pollAccount");
            return null;
        }
    }

    @Override
    public boolean updateVote(VoteDTO voteDTO) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)this.voteDAO.findByTopiaId(voteDTO.getId());
            this.converter.setTransaction(transaction);
            this.converter.populateVoteEntity(voteDTO, voteEntity);
            voteEntity.update();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + voteDTO.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public boolean deleteVote(String voteId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)this.voteDAO.findByTopiaId(voteId);
            voteEntity.delete();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + voteId));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public List<VoteDTO> selectVotes(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<VoteDTO> results = null;
        List voteEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            if (properties == null) {
                voteEntities = this.voteDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les votes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                voteEntities = this.voteDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createVoteDTOs(voteEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }
}

