/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class UserAccountAbstract
extends TopiaEntityAbstract
implements UserAccount {
    public String login;
    public String password;
    public String firstName;
    public String lastName;
    public Boolean administrator;
    public String language;
    public String email;
    public List<PersonList> favoriteList;
    public List<PollAccount> pollAccount;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(UserAccount.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(UserAccount.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "login", String.class, (Object)this.login);
        visitor.visit((TopiaEntity)this, "password", String.class, (Object)this.password);
        visitor.visit((TopiaEntity)this, "firstName", String.class, (Object)this.firstName);
        visitor.visit((TopiaEntity)this, "lastName", String.class, (Object)this.lastName);
        visitor.visit((TopiaEntity)this, "administrator", Boolean.class, (Object)this.administrator);
        visitor.visit((TopiaEntity)this, "language", String.class, (Object)this.language);
        visitor.visit((TopiaEntity)this, "email", String.class, (Object)this.email);
        visitor.visit((TopiaEntity)this, "favoriteList", List.class, PersonList.class, this.favoriteList);
        visitor.visit((TopiaEntity)this, "pollAccount", List.class, PollAccount.class, this.pollAccount);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setLogin(String value) {
        String _oldValue = this.login;
        this.fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        this.fireOnPostWrite("login", _oldValue, value);
    }

    @Override
    public String getLogin() {
        this.fireOnPreRead("login", this.login);
        String result = this.login;
        this.fireOnPostRead("login", this.login);
        return result;
    }

    @Override
    public void setPassword(String value) {
        String _oldValue = this.password;
        this.fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        this.fireOnPostWrite("password", _oldValue, value);
    }

    @Override
    public String getPassword() {
        this.fireOnPreRead("password", this.password);
        String result = this.password;
        this.fireOnPostRead("password", this.password);
        return result;
    }

    @Override
    public void setFirstName(String value) {
        String _oldValue = this.firstName;
        this.fireOnPreWrite("firstName", _oldValue, value);
        this.firstName = value;
        this.fireOnPostWrite("firstName", _oldValue, value);
    }

    @Override
    public String getFirstName() {
        this.fireOnPreRead("firstName", this.firstName);
        String result = this.firstName;
        this.fireOnPostRead("firstName", this.firstName);
        return result;
    }

    @Override
    public void setLastName(String value) {
        String _oldValue = this.lastName;
        this.fireOnPreWrite("lastName", _oldValue, value);
        this.lastName = value;
        this.fireOnPostWrite("lastName", _oldValue, value);
    }

    @Override
    public String getLastName() {
        this.fireOnPreRead("lastName", this.lastName);
        String result = this.lastName;
        this.fireOnPostRead("lastName", this.lastName);
        return result;
    }

    @Override
    public void setAdministrator(Boolean value) {
        Boolean _oldValue = this.administrator;
        this.fireOnPreWrite("administrator", _oldValue, value);
        this.administrator = value;
        this.fireOnPostWrite("administrator", _oldValue, value);
    }

    @Override
    public Boolean getAdministrator() {
        this.fireOnPreRead("administrator", this.administrator);
        Boolean result = this.administrator;
        this.fireOnPostRead("administrator", this.administrator);
        return result;
    }

    @Override
    public void setLanguage(String value) {
        String _oldValue = this.language;
        this.fireOnPreWrite("language", _oldValue, value);
        this.language = value;
        this.fireOnPostWrite("language", _oldValue, value);
    }

    @Override
    public String getLanguage() {
        this.fireOnPreRead("language", this.language);
        String result = this.language;
        this.fireOnPostRead("language", this.language);
        return result;
    }

    @Override
    public void setEmail(String value) {
        String _oldValue = this.email;
        this.fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        this.fireOnPostWrite("email", _oldValue, value);
    }

    @Override
    public String getEmail() {
        this.fireOnPreRead("email", this.email);
        String result = this.email;
        this.fireOnPostRead("email", this.email);
        return result;
    }

    @Override
    public void addFavoriteList(PersonList favoriteList) {
        this.fireOnPreWrite("favoriteList", null, favoriteList);
        if (this.favoriteList == null) {
            this.favoriteList = new ArrayList<PersonList>();
        }
        favoriteList.setOwner(this);
        this.favoriteList.add(favoriteList);
        this.fireOnPostWrite("favoriteList", this.favoriteList.size(), null, favoriteList);
    }

    @Override
    public void addAllFavoriteList(List<PersonList> values) {
        if (values == null) {
            return;
        }
        for (PersonList item : values) {
            this.addFavoriteList(item);
        }
    }

    @Override
    public PersonList getFavoriteListByTopiaId(String topiaId) {
        return (PersonList)TopiaEntityHelper.getEntityByTopiaId(this.favoriteList, (String)topiaId);
    }

    @Override
    public void setFavoriteList(List<PersonList> values) {
        List<PersonList> _oldValue = this.favoriteList;
        this.fireOnPreWrite("favoriteList", _oldValue, values);
        this.favoriteList = values;
        this.fireOnPostWrite("favoriteList", _oldValue, values);
    }

    @Override
    public void removeFavoriteList(PersonList value) {
        this.fireOnPreWrite("favoriteList", value, null);
        if (this.favoriteList == null || !this.favoriteList.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setOwner(null);
        this.fireOnPostWrite("favoriteList", this.favoriteList.size() + 1, value, null);
    }

    @Override
    public void clearFavoriteList() {
        if (this.favoriteList == null) {
            return;
        }
        for (PersonList item : this.favoriteList) {
            item.setOwner(null);
        }
        ArrayList<PersonList> _oldValue = new ArrayList<PersonList>(this.favoriteList);
        this.fireOnPreWrite("favoriteList", _oldValue, this.favoriteList);
        this.favoriteList.clear();
        this.fireOnPostWrite("favoriteList", _oldValue, this.favoriteList);
    }

    @Override
    public List<PersonList> getFavoriteList() {
        return this.favoriteList;
    }

    @Override
    public int sizeFavoriteList() {
        if (this.favoriteList == null) {
            return 0;
        }
        return this.favoriteList.size();
    }

    @Override
    public boolean isFavoriteListEmpty() {
        int size = this.sizeFavoriteList();
        return size == 0;
    }

    @Override
    public void addPollAccount(PollAccount pollAccount) {
        this.fireOnPreWrite("pollAccount", null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }
        pollAccount.setUserAccount(this);
        this.pollAccount.add(pollAccount);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size(), null, pollAccount);
    }

    @Override
    public void addAllPollAccount(List<PollAccount> values) {
        if (values == null) {
            return;
        }
        for (PollAccount item : values) {
            this.addPollAccount(item);
        }
    }

    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return (PollAccount)TopiaEntityHelper.getEntityByTopiaId(this.pollAccount, (String)topiaId);
    }

    @Override
    public void setPollAccount(List<PollAccount> values) {
        List<PollAccount> _oldValue = this.pollAccount;
        this.fireOnPreWrite("pollAccount", _oldValue, values);
        this.pollAccount = values;
        this.fireOnPostWrite("pollAccount", _oldValue, values);
    }

    @Override
    public void removePollAccount(PollAccount value) {
        this.fireOnPreWrite("pollAccount", value, null);
        if (this.pollAccount == null || !this.pollAccount.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setUserAccount(null);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size() + 1, value, null);
    }

    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setUserAccount(null);
        }
        ArrayList<PollAccount> _oldValue = new ArrayList<PollAccount>(this.pollAccount);
        this.fireOnPreWrite("pollAccount", _oldValue, this.pollAccount);
        this.pollAccount.clear();
        this.fireOnPostWrite("pollAccount", _oldValue, this.pollAccount);
    }

    @Override
    public List<PollAccount> getPollAccount() {
        return this.pollAccount;
    }

    @Override
    public int sizePollAccount() {
        if (this.pollAccount == null) {
            return 0;
        }
        return this.pollAccount.size();
    }

    @Override
    public boolean isPollAccountEmpty() {
        int size = this.sizePollAccount();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("login", (Object)this.login).append("password", (Object)this.password).append("firstName", (Object)this.firstName).append("lastName", (Object)this.lastName).append("administrator", (Object)this.administrator).append("language", (Object)this.language).append("email", (Object)this.email).toString();
        return result;
    }
}

