/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.nuiton.topia.TopiaException;

public class DataCommentConverter
extends DataConverter {
    public void populateCommentEntity(CommentDTO commentDTO, Comment eComment) throws TopiaException {
        eComment.setText(commentDTO.getText());
        eComment.setPostDate(commentDTO.getPostDate());
        if (commentDTO.getPollId().length() > 0) {
            PollDAO pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)pollDAO.findByTopiaId(commentDTO.getPollId());
            eComment.setPoll(pollEntity);
        }
        if (commentDTO.getPollAccountId().length() > 0) {
            PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)pollAccountDAO.findByTopiaId(commentDTO.getPollAccountId());
            eComment.setPollAccount(pollAccountEntity);
        }
    }

    public CommentDTO createCommentDTO(Comment eComment) {
        CommentDTO commentDTO = new CommentDTO();
        commentDTO.setId(eComment.getTopiaId());
        commentDTO.setText(eComment.getText());
        commentDTO.setPostDate(eComment.getPostDate());
        if (eComment.getPoll() != null) {
            commentDTO.setPollId(eComment.getPoll().getTopiaId());
        }
        if (eComment.getPollAccount() != null) {
            commentDTO.setPollAccountId(eComment.getPollAccount().getVotingId());
        }
        return commentDTO;
    }

    public List<CommentDTO> createCommentDTOs(Collection<Comment> cComments) {
        ArrayList<CommentDTO> results = new ArrayList<CommentDTO>();
        for (Comment c : cComments) {
            CommentDTO dto = this.createCommentDTO(c);
            results.add(dto);
        }
        return results;
    }
}

