/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link UserAccount}.
 */
public abstract class UserAccountAbstract extends TopiaEntityAbstract implements UserAccount {

    public String login;

    public String password;

    public String firstName;

    public String lastName;

    public Boolean administrator;

    public String language;

    public String email;

    public List<PersonList> favoriteList;

    public List<PollAccount> pollAccount;

    /**
     * Constructeur de UserAccountAbstract par défaut.
     */
    public UserAccountAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(UserAccount.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(UserAccount.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "login", String.class, login);
        visitor.visit(this, "password", String.class, password);
        visitor.visit(this, "firstName", String.class, firstName);
        visitor.visit(this, "lastName", String.class, lastName);
        visitor.visit(this, "administrator", Boolean.class, administrator);
        visitor.visit(this, "language", String.class, language);
        visitor.visit(this, "email", String.class, email);
        visitor.visit(this, "favoriteList", List.class, PersonList.class, favoriteList);
        visitor.visit(this, "pollAccount", List.class, PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setLogin(String)
     */
    @Override
    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        fireOnPostWrite("login", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getLogin()
     */
    @Override
    public String getLogin() {
        fireOnPreRead("login", login);
        String result = this.login;
        fireOnPostRead("login", login);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setPassword(String)
     */
    @Override
    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        fireOnPostWrite("password", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getPassword()
     */
    @Override
    public String getPassword() {
        fireOnPreRead("password", password);
        String result = this.password;
        fireOnPostRead("password", password);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setFirstName(String)
     */
    @Override
    public void setFirstName(String value) {
        String _oldValue = this.firstName;
        fireOnPreWrite("firstName", _oldValue, value);
        this.firstName = value;
        fireOnPostWrite("firstName", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getFirstName()
     */
    @Override
    public String getFirstName() {
        fireOnPreRead("firstName", firstName);
        String result = this.firstName;
        fireOnPostRead("firstName", firstName);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setLastName(String)
     */
    @Override
    public void setLastName(String value) {
        String _oldValue = this.lastName;
        fireOnPreWrite("lastName", _oldValue, value);
        this.lastName = value;
        fireOnPostWrite("lastName", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getLastName()
     */
    @Override
    public String getLastName() {
        fireOnPreRead("lastName", lastName);
        String result = this.lastName;
        fireOnPostRead("lastName", lastName);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setAdministrator(Boolean)
     */
    @Override
    public void setAdministrator(Boolean value) {
        Boolean _oldValue = this.administrator;
        fireOnPreWrite("administrator", _oldValue, value);
        this.administrator = value;
        fireOnPostWrite("administrator", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getAdministrator()
     */
    @Override
    public Boolean getAdministrator() {
        fireOnPreRead("administrator", administrator);
        Boolean result = this.administrator;
        fireOnPostRead("administrator", administrator);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setLanguage(String)
     */
    @Override
    public void setLanguage(String value) {
        String _oldValue = this.language;
        fireOnPreWrite("language", _oldValue, value);
        this.language = value;
        fireOnPostWrite("language", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getLanguage()
     */
    @Override
    public String getLanguage() {
        fireOnPreRead("language", language);
        String result = this.language;
        fireOnPostRead("language", language);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#setEmail(String)
     */
    @Override
    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        fireOnPostWrite("email", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see UserAccount#getEmail()
     */
    @Override
    public String getEmail() {
        fireOnPreRead("email", email);
        String result = this.email;
        fireOnPostRead("email", email);
        return result;
    }

    /* (non-Javadoc)
     * @see UserAccount#addFavoriteList(PersonList)
     */
    @Override
    public void addFavoriteList(PersonList favoriteList) {
        fireOnPreWrite("favoriteList", null, favoriteList);
        if (this.favoriteList == null) {
            this.favoriteList = new ArrayList<PersonList>();
        }
        favoriteList.setOwner(this);
        this.favoriteList.add(favoriteList);
        fireOnPostWrite("favoriteList", this.favoriteList.size(), null, favoriteList);
    }

    /* (non-Javadoc)
     * @see UserAccount#addAllFavoriteList(List<PersonList>)
     */
    @Override
    public void addAllFavoriteList(List<PersonList> values) {
        if (values == null) {
            return;
        }
        for (PersonList item : values) {
            addFavoriteList(item);
        }
    }

    /* (non-Javadoc)
     * @see UserAccount#getFavoriteListByTopiaId(String)
     */
    @Override
    public PersonList getFavoriteListByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(favoriteList, topiaId);
    }
 
    /* (non-Javadoc)
     * @see UserAccount#setFavoriteList(List<PersonList>)
     */
    @Override
    public void setFavoriteList(List<PersonList> values) {
        List<PersonList> _oldValue = favoriteList;
        fireOnPreWrite("favoriteList", _oldValue, values);
        favoriteList = values;
        fireOnPostWrite("favoriteList", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see UserAccount#removeFavoriteList(PersonList)
     */
    @Override
    public void removeFavoriteList(PersonList value) {
        fireOnPreWrite("favoriteList", value, null);
        if ((this.favoriteList == null) || (!this.favoriteList.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setOwner(null);
        fireOnPostWrite("favoriteList", this.favoriteList.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see UserAccount#clearFavoriteList()
     */
    @Override
    public void clearFavoriteList() {
        if (this.favoriteList == null) {
            return;
        }
        for (PersonList item : this.favoriteList) {
            item.setOwner(null);
        }
        List<PersonList> _oldValue = new ArrayList<PersonList>(this.favoriteList);
        fireOnPreWrite("favoriteList", _oldValue, this.favoriteList);
        this.favoriteList.clear();
        fireOnPostWrite("favoriteList", _oldValue, this.favoriteList);
    }

    /* (non-Javadoc)
     * @see UserAccount#getFavoriteList()
     */
    @Override
    public List<PersonList> getFavoriteList() {
        return favoriteList;
    }

    /* (non-Javadoc)
     * @see UserAccount#sizeFavoriteList()
     */
    @Override
    public int sizeFavoriteList() {
        if (favoriteList == null) {
            return 0;
        }
        return favoriteList.size();
    }

    /* (non-Javadoc)
     * @see UserAccount#isFavoriteListEmpty()
     */
    @Override
    public boolean isFavoriteListEmpty() {
        int size = sizeFavoriteList();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see UserAccount#addPollAccount(PollAccount)
     */
    @Override
    public void addPollAccount(PollAccount pollAccount) {
        fireOnPreWrite("pollAccount", null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }
        pollAccount.setUserAccount(this);
        this.pollAccount.add(pollAccount);
        fireOnPostWrite("pollAccount", this.pollAccount.size(), null, pollAccount);
    }

    /* (non-Javadoc)
     * @see UserAccount#addAllPollAccount(List<PollAccount>)
     */
    @Override
    public void addAllPollAccount(List<PollAccount> values) {
        if (values == null) {
            return;
        }
        for (PollAccount item : values) {
            addPollAccount(item);
        }
    }

    /* (non-Javadoc)
     * @see UserAccount#getPollAccountByTopiaId(String)
     */
    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(pollAccount, topiaId);
    }
 
    /* (non-Javadoc)
     * @see UserAccount#setPollAccount(List<PollAccount>)
     */
    @Override
    public void setPollAccount(List<PollAccount> values) {
        List<PollAccount> _oldValue = pollAccount;
        fireOnPreWrite("pollAccount", _oldValue, values);
        pollAccount = values;
        fireOnPostWrite("pollAccount", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see UserAccount#removePollAccount(PollAccount)
     */
    @Override
    public void removePollAccount(PollAccount value) {
        fireOnPreWrite("pollAccount", value, null);
        if ((this.pollAccount == null) || (!this.pollAccount.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setUserAccount(null);
        fireOnPostWrite("pollAccount", this.pollAccount.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see UserAccount#clearPollAccount()
     */
    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setUserAccount(null);
        }
        List<PollAccount> _oldValue = new ArrayList<PollAccount>(this.pollAccount);
        fireOnPreWrite("pollAccount", _oldValue, this.pollAccount);
        this.pollAccount.clear();
        fireOnPostWrite("pollAccount", _oldValue, this.pollAccount);
    }

    /* (non-Javadoc)
     * @see UserAccount#getPollAccount()
     */
    @Override
    public List<PollAccount> getPollAccount() {
        return pollAccount;
    }

    /* (non-Javadoc)
     * @see UserAccount#sizePollAccount()
     */
    @Override
    public int sizePollAccount() {
        if (pollAccount == null) {
            return 0;
        }
        return pollAccount.size();
    }

    /* (non-Javadoc)
     * @see UserAccount#isPollAccountEmpty()
     */
    @Override
    public boolean isPollAccountEmpty() {
        int size = sizePollAccount();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("login", this.login).
            append("password", this.password).
            append("firstName", this.firstName).
            append("lastName", this.lastName).
            append("administrator", this.administrator).
            append("language", this.language).
            append("email", this.email).
         toString();
        return result;
    }
        
} //UserAccountAbstract
