/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité PollAccount.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class PollAccountDAOAbstract<E extends PollAccount> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)PollAccount.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.Poll> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Poll.class)
                            .findAllByProperties("creator", entity);
                    for (org.chorem.pollen.business.persistence.Poll item : list) {
                        item.setCreator(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.Comment> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Comment.class)
                            .findAllByProperties("pollAccount", entity);
                    for (org.chorem.pollen.business.persistence.Comment item : list) {
                        item.setPollAccount(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.Vote> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Vote.class)
                            .findAllByProperties("pollAccount", entity);
                    for (org.chorem.pollen.business.persistence.Vote item : list) {
                        item.setPollAccount(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut accountId
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * accountId le paramètre
     * @param v la valeur que doit avoir accountId
     * @return un element ou null
     */
    public E findByAccountId(java.lang.String v) throws TopiaException {
        E result = findByProperty("accountId", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * accountId le paramètre
     * @param v la valeur que doit avoir accountId
     * @return une liste
     */
    public List<E> findAllByAccountId(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("accountId", v);
        return result;
    }
    /**
     * Recherche sur l'attribut votingId
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * votingId le paramètre
     * @param v la valeur que doit avoir votingId
     * @return un element ou null
     */
    public E findByVotingId(java.lang.String v) throws TopiaException {
        E result = findByProperty("votingId", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * votingId le paramètre
     * @param v la valeur que doit avoir votingId
     * @return une liste
     */
    public List<E> findAllByVotingId(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("votingId", v);
        return result;
    }
    /**
     * Recherche sur l'attribut email
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return un element ou null
     */
    public E findByEmail(java.lang.String v) throws TopiaException {
        E result = findByProperty("email", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return une liste
     */
    public List<E> findAllByEmail(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("email", v);
        return result;
    }
    /**
     * Recherche sur l'attribut votingList
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * votingList contient le paramètre
     * @param v la valeur que doit contenir votingList
     * @return un element ou null
     */
    public E findContainsVotingList(org.chorem.pollen.business.persistence.VotingList ... v) throws TopiaException {
        E result = findContainsProperties("votingList", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * votingList contient le paramètre
     * @param v la valeur que doit contenir votingList
     * @return une liste
     */
    public List<E> findAllContainsVotingList(org.chorem.pollen.business.persistence.VotingList ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("votingList", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut pollsCreated
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * pollsCreated contient le paramètre
     * @param v la valeur que doit contenir pollsCreated
     * @return un element ou null
     */
    public E findContainsPollsCreated(org.chorem.pollen.business.persistence.Poll ... v) throws TopiaException {
        E result = findContainsProperties("pollsCreated", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * pollsCreated contient le paramètre
     * @param v la valeur que doit contenir pollsCreated
     * @return une liste
     */
    public List<E> findAllContainsPollsCreated(org.chorem.pollen.business.persistence.Poll ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("pollsCreated", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut comment
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * comment contient le paramètre
     * @param v la valeur que doit contenir comment
     * @return un element ou null
     */
    public E findContainsComment(org.chorem.pollen.business.persistence.Comment ... v) throws TopiaException {
        E result = findContainsProperties("comment", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * comment contient le paramètre
     * @param v la valeur que doit contenir comment
     * @return une liste
     */
    public List<E> findAllContainsComment(org.chorem.pollen.business.persistence.Comment ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("comment", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut vote
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return un element ou null
     */
    public E findContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        E result = findContainsProperties("vote", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return une liste
     */
    public List<E> findAllContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("vote", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut personList
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * personList le paramètre
     * @param v la valeur que doit avoir personList
     * @return un element ou null
     */
    public E findByPersonList(org.chorem.pollen.business.persistence.PersonList v) throws TopiaException {
        E result = findByProperty("personList", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * personList le paramètre
     * @param v la valeur que doit avoir personList
     * @return une liste
     */
    public List<E> findAllByPersonList(org.chorem.pollen.business.persistence.PersonList v) throws TopiaException {
        List<E> result = findAllByProperty("personList", v);
        return result;
    }
    /**
     * Recherche sur l'attribut userAccount
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * userAccount le paramètre
     * @param v la valeur que doit avoir userAccount
     * @return un element ou null
     */
    public E findByUserAccount(org.chorem.pollen.business.persistence.UserAccount v) throws TopiaException {
        E result = findByProperty("userAccount", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * userAccount le paramètre
     * @param v la valeur que doit avoir userAccount
     * @return une liste
     */
    public List<E> findAllByUserAccount(org.chorem.pollen.business.persistence.UserAccount v) throws TopiaException {
        List<E> result = findAllByProperty("userAccount", v);
        return result;
    }

} // PollAccountDAOAbstract
