/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité PersonToList.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class PersonToListDAOAbstract<E extends PersonToList> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)PersonToList.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut weight
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * weight le paramètre
     * @param v la valeur que doit avoir weight
     * @return un element ou null
     */
    public E findByWeight(java.lang.Double v) throws TopiaException {
        E result = findByProperty("weight", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * weight le paramètre
     * @param v la valeur que doit avoir weight
     * @return une liste
     */
    public List<E> findAllByWeight(java.lang.Double v) throws TopiaException {
        List<E> result = findAllByProperty("weight", v);
        return result;
    }
    /**
     * Recherche sur l'attribut hasVoted
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * hasVoted le paramètre
     * @param v la valeur que doit avoir hasVoted
     * @return un element ou null
     */
    public E findByHasVoted(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("hasVoted", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * hasVoted le paramètre
     * @param v la valeur que doit avoir hasVoted
     * @return une liste
     */
    public List<E> findAllByHasVoted(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("hasVoted", v);
        return result;
    }
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * votingList contient le paramètre
     * @param v la valeur que doit contenir votingList
     * @return un element ou null
     */
    public E findContainsVotingList(org.chorem.pollen.business.persistence.VotingList ... v) throws TopiaException {
        E result = findContainsProperties("votingList", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * votingList contient le paramètre
     * @param v la valeur que doit contenir votingList
     * @return une liste
     */
    public List<E> findAllContainsVotingList(org.chorem.pollen.business.persistence.VotingList ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("votingList", Arrays.asList(v));
        return results;
    }
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return un element ou null
     */
    public E findContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        E result = findContainsProperties("pollAccount", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return une liste
     */
    public List<E> findAllContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("pollAccount", Arrays.asList(v));
        return results;
    }

} // PersonToListDAOAbstract
