/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PersonListAbstract
extends TopiaEntityAbstract
implements PersonList {
    public String name;
    public UserAccount owner;
    public List<PollAccount> pollAccount;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(PersonList.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(PersonList.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "owner", UserAccount.class, (Object)this.owner);
        visitor.visit((TopiaEntity)this, "pollAccount", List.class, PollAccount.class, this.pollAccount);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<PollAccount> tmp = new ArrayList<PollAccount>();
        tmp.addAll(this.getPollAccount());
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setOwner(UserAccount value) {
        UserAccount _oldValue = this.owner;
        this.fireOnPreWrite("owner", _oldValue, value);
        this.owner = value;
        this.fireOnPostWrite("owner", _oldValue, value);
    }

    @Override
    public UserAccount getOwner() {
        this.fireOnPreRead("owner", this.owner);
        UserAccount result = this.owner;
        this.fireOnPostRead("owner", this.owner);
        return result;
    }

    @Override
    public void addPollAccount(PollAccount pollAccount) {
        this.fireOnPreWrite("pollAccount", null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }
        pollAccount.setPersonList(this);
        this.pollAccount.add(pollAccount);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size(), null, pollAccount);
    }

    @Override
    public void addAllPollAccount(List<PollAccount> values) {
        if (values == null) {
            return;
        }
        for (PollAccount item : values) {
            this.addPollAccount(item);
        }
    }

    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return (PollAccount)TopiaEntityHelper.getEntityByTopiaId(this.pollAccount, (String)topiaId);
    }

    @Override
    public void setPollAccount(List<PollAccount> values) {
        List<PollAccount> _oldValue = this.pollAccount;
        this.fireOnPreWrite("pollAccount", _oldValue, values);
        this.pollAccount = values;
        this.fireOnPostWrite("pollAccount", _oldValue, values);
    }

    @Override
    public void removePollAccount(PollAccount value) {
        this.fireOnPreWrite("pollAccount", value, null);
        if (this.pollAccount == null || !this.pollAccount.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPersonList(null);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size() + 1, value, null);
    }

    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setPersonList(null);
        }
        ArrayList<PollAccount> _oldValue = new ArrayList<PollAccount>(this.pollAccount);
        this.fireOnPreWrite("pollAccount", _oldValue, this.pollAccount);
        this.pollAccount.clear();
        this.fireOnPostWrite("pollAccount", _oldValue, this.pollAccount);
    }

    @Override
    public List<PollAccount> getPollAccount() {
        return this.pollAccount;
    }

    @Override
    public int sizePollAccount() {
        if (this.pollAccount == null) {
            return 0;
        }
        return this.pollAccount.size();
    }

    @Override
    public boolean isPollAccountEmpty() {
        int size = this.sizePollAccount();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).toString();
        return result;
    }
}

