/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.business.converters.DataChoiceConverter;
import org.chorem.pollen.business.converters.DataCommentConverter;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.DataPreventRuleConverter;
import org.chorem.pollen.business.converters.DataVoteConverter;
import org.chorem.pollen.business.converters.DataVotingListConverter;
import org.chorem.pollen.business.converters.EnumController;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.nuiton.topia.TopiaException;

public class DataPollConverter
extends DataConverter {
    DataChoiceConverter choiceConverter = new DataChoiceConverter();
    DataVoteConverter voteConverter = new DataVoteConverter();
    DataCommentConverter commentConverter = new DataCommentConverter();
    DataPreventRuleConverter preventRuleConverter = new DataPreventRuleConverter();
    DataVotingListConverter votingListConverter = new DataVotingListConverter();

    public void populatePollEntity(PollDTO pollDTO, Poll ePoll) throws TopiaException {
        ePoll.setPollId(pollDTO.getPollId());
        ePoll.setTitle(pollDTO.getTitle());
        ePoll.setDescription(pollDTO.getDescription());
        ePoll.setBeginChoiceDate(pollDTO.getBeginChoiceDate());
        ePoll.setBeginDate(pollDTO.getBeginDate());
        ePoll.setEndDate(pollDTO.getEndDate());
        ePoll.setClosed(pollDTO.isClosed());
        ePoll.setAnonymous(pollDTO.isAnonymous());
        ePoll.setAnonymousVoteAllowed(pollDTO.isAnonymousVoteAllowed());
        ePoll.setPublicResults(pollDTO.isPublicResults());
        ePoll.setContinuousResults(pollDTO.isContinuousResults());
        ePoll.setChoiceAddAllowed(pollDTO.isChoiceAddAllowed());
        ePoll.setMaxChoiceNb(pollDTO.getMaxChoiceNb());
        EnumController enumCtrl = new EnumController(this.transaction);
        enumCtrl.setChoiceType(pollDTO.getChoiceType(), ePoll);
        enumCtrl.setPollType(pollDTO.getPollType(), ePoll);
        enumCtrl.setVoteCounting(pollDTO.getVoteCounting(), ePoll);
    }

    public PollDTO createPollDTO(Poll ePoll) {
        PollDTO pollDTO = new PollDTO();
        pollDTO.setId(ePoll.getTopiaId());
        pollDTO.setPollId(ePoll.getPollId());
        pollDTO.setTitle(ePoll.getTitle());
        pollDTO.setDescription(ePoll.getDescription());
        pollDTO.setBeginChoiceDate(ePoll.getBeginChoiceDate());
        pollDTO.setBeginDate(ePoll.getBeginDate());
        pollDTO.setEndDate(ePoll.getEndDate());
        pollDTO.setAnonymous(ePoll.getAnonymous());
        pollDTO.setAnonymousVoteAllowed(ePoll.getAnonymousVoteAllowed());
        pollDTO.setPublicResults(ePoll.getPublicResults());
        pollDTO.setContinuousResults(ePoll.getContinuousResults());
        pollDTO.setChoiceAddAllowed(ePoll.getChoiceAddAllowed());
        pollDTO.setClosed(ePoll.getClosed());
        pollDTO.setMaxChoiceNb(ePoll.getMaxChoiceNb());
        pollDTO.setChoiceType(EnumController.getChoiceType(ePoll));
        pollDTO.setPollType(EnumController.getPollType(ePoll));
        pollDTO.setVoteCounting(EnumController.getVoteCountingType(ePoll));
        if (ePoll.getCreator() != null) {
            pollDTO.setCreatorId(ePoll.getCreator().getTopiaId());
            pollDTO.setCreatorEmail(ePoll.getCreator().getEmail());
        }
        if (ePoll.getChoice().size() > 0) {
            pollDTO.setChoiceDTOs(this.choiceConverter.createChoiceDTOs(ePoll.getChoice()));
        }
        if (ePoll.getVote().size() > 0) {
            pollDTO.setVoteDTOs(this.voteConverter.createVoteDTOs(ePoll.getVote()));
        }
        if (ePoll.getComment().size() > 0) {
            pollDTO.setCommentDTOs(this.commentConverter.createCommentDTOs(ePoll.getComment()));
        }
        if (ePoll.getPreventRule().size() > 0) {
            pollDTO.setPreventRuleDTOs(this.preventRuleConverter.createPreventRuleDTOs(ePoll.getPreventRule()));
        }
        if (ePoll.getVotingList().size() > 0) {
            pollDTO.setVotingListDTOs(this.votingListConverter.createVotingListDTOs(ePoll.getVotingList()));
        }
        return pollDTO;
    }

    public List<PollDTO> createPollDTOs(List<Poll> lPolls) {
        ArrayList<PollDTO> results = new ArrayList<PollDTO>();
        for (Poll p : lPolls) {
            PollDTO dto = this.createPollDTO(p);
            results.add(dto);
        }
        return results;
    }
}

