/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServicePollAccount;
import org.chorem.pollen.business.converters.DataPollAccountConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServicePollAccountImpl
implements ServicePollAccount {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private PollAccountDAO pollAccountDAO = null;
    private DataPollAccountConverter converter = new DataPollAccountConverter();
    private static final Log log = LogFactory.getLog(ServicePollAccountImpl.class);

    @Override
    public String createPollAccount(PollAccountDTO pollAccountDTO) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.create(new Object[0]);
            this.converter.setTransaction(this.transaction);
            this.converter.populatePollAccountEntity(pollAccountDTO, pollAccountEntity);
            String topiaId = pollAccountEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public PollAccount createPollAccount(String votingId, String email, String userId) {
        PollAccount pollAccountEntity = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            pollAccountEntity = (PollAccount)this.pollAccountDAO.create(new Object[0]);
            this.converter.setTransaction(this.transaction);
            this.converter.populatePollAccountEntity(votingId, email, userId, pollAccountEntity);
            String topiaId = pollAccountEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return pollAccountEntity;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PollAccount> createPollAccounts(List<PollAccountDTO> pollAccounts, TopiaContext trans) {
        if (pollAccounts.isEmpty()) {
            return null;
        }
        ArrayList<PollAccount> result = null;
        try {
            this.transaction = trans;
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            this.converter.setTransaction(this.transaction);
            result = new ArrayList<PollAccount>();
            for (PollAccountDTO pollAccount : pollAccounts) {
                PollAccount entity = (PollAccount)this.pollAccountDAO.create(new Object[0]);
                pollAccount.setId(entity.getTopiaId());
                this.converter.populatePollAccountEntity(pollAccount, entity);
                result.add(entity);
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean deletePollAccount(String pollAccountId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.findByTopiaId(pollAccountId);
            this.pollAccountDAO.delete(pollAccountEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + pollAccountId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean updatePollAccount(PollAccountDTO pollAccountDTO) {
        boolean resu = false;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.findByTopiaId(pollAccountDTO.getId());
            if (pollAccountEntity != null) {
                this.converter.setTransaction(this.transaction);
                this.converter.populatePollAccountEntity(pollAccountDTO, pollAccountEntity);
                this.pollAccountDAO.update(pollAccountEntity);
                this.transaction.commitTransaction();
                resu = true;
            }
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + pollAccountDTO.getId()));
            }
            return resu;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public PollAccountDTO findPollAccountById(String pollAccountId) {
        PollAccountDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.findByTopiaId(pollAccountId);
            if (pollAccountEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createPollAccountDTO(pollAccountEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<PollAccountDTO> findPollAccountsByUser(String userId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<PollAccountDTO> selectPollAccounts(Map<String, Object> properties) {
        List<PollAccountDTO> results = null;
        List pollAccountEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            if (properties == null) {
                pollAccountEntities = this.pollAccountDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les comptes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                pollAccountEntities = this.pollAccountDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createPollAccountDTOs(pollAccountEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

