/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceComment;
import org.chorem.pollen.business.ServicePollAccountImpl;
import org.chorem.pollen.business.converters.DataCommentConverter;
import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceCommentImpl
implements ServiceComment {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private CommentDAO commentDAO = null;
    private DataCommentConverter converter = new DataCommentConverter();
    private static final Log log = LogFactory.getLog(ServiceCommentImpl.class);

    @Override
    public String createComment(CommentDTO comment) {
        String topiaId = "";
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(this.transaction);
            Comment commentEntity = (Comment)this.commentDAO.create(new Object[0]);
            this.converter.setTransaction(this.transaction);
            this.converter.populateCommentEntity(comment, commentEntity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            commentEntity.setPollAccount(spa.createPollAccount(comment.getPollAccountId(), null, null));
            topiaId = commentEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return "";
        }
    }

    @Override
    public List<Comment> createComments(List<CommentDTO> comments, String pollId, TopiaContext trans) {
        if (comments.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<Comment> result = null;
        try {
            this.transaction = trans;
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(trans);
            this.converter.setTransaction(trans);
            result = new ArrayList<Comment>();
            for (CommentDTO comment : comments) {
                Comment commentEntity = (Comment)this.commentDAO.create(new Object[0]);
                comment.setPollId(pollId);
                this.converter.populateCommentEntity(comment, commentEntity);
                result.add(commentEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean updateComment(CommentDTO comment) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(this.transaction);
            Comment commentEntity = (Comment)this.commentDAO.findByTopiaId(comment.getId());
            this.converter.setTransaction(this.transaction);
            this.converter.populateCommentEntity(comment, commentEntity);
            this.commentDAO.update(commentEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + comment.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deleteComment(String commentId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(this.transaction);
            Comment commentEntity = (Comment)this.commentDAO.findByTopiaId(commentId);
            this.commentDAO.delete(commentEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + commentId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public CommentDTO findCommentById(String commentId) {
        CommentDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(this.transaction);
            Comment commentEntity = (Comment)this.commentDAO.findByTopiaId(commentId);
            if (commentEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createCommentDTO(commentEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<CommentDTO> selectComments(Map<String, Object> properties) {
        List<CommentDTO> results = null;
        List commentEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(this.transaction);
            if (properties == null) {
                commentEntities = this.commentDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les commentaires ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                commentEntities = this.commentDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createCommentDTOs(commentEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

