/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.utils;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

/**
 * Charge les propriétés du fichier properties pour la configuration de la base
 * de données
 *
 * @author rannou
 * @version $Id: PropertiesLoader.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PropertiesLoader {

    /** log. */
    private static final Log log = LogFactory.getLog(PropertiesLoader.class);

    /**
     * Charge le fichier properties et retourne les propriétés créées
     *
     * @param filename Le fichier properties
     * @return Les propriétés de la base de données
     */
    public static Properties loadPropertiesFile(String filename) {
        Properties conf = null;

        try {
            conf = new Properties();

            //URL url = Resource.getURL(filename);
            //conf.load(url.openStream());

            Properties confAll = Resource.getConfigProperties(filename);
            for (String key : confAll.stringPropertyNames()) {
                conf.setProperty(key, confAll.getProperty(key));
            }

            if (log.isDebugEnabled()) {
                log.debug("Propriétés: " + conf);
            }
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Lecture impossible du fichier de propriétés : "
                        + filename);
            }
            ex.printStackTrace();
        }

        return conf;
    }
}
