/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

/**
 * Classe permettant d'envoyer des mails. Basée sur SimpleMail.
 *
 * @author rannou
 * @version $Id: MailUtil.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class MailUtil {

    /** log. */
    private static final Log log = LogFactory.getLog(MailUtil.class);

    /**
     * Envoi d'un email.
     *
     * @param host Nom du serveur
     * @param port Port SMTP
     * @param from Adresse email de l'expéditeur
     * @param to Adresse email du destinataire
     * @param subject Sujet
     * @param msg Message
     */
    public static void sendMail(String host, int port, String from, String to,
            String subject, String msg) {
        SimpleEmail email = new SimpleEmail();
        try {
            email.setHostName(host);
            email.setSmtpPort(port);
            email.setFrom(from);
            email.addTo(to);
            email.setSubject(subject);
            email.setMsg(msg);
            email.send();
        } catch (EmailException e) {
            e.printStackTrace();
        }

        if (log.isInfoEnabled()) {
            log.info("Email envoyé.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Détail de l'email : " + "\ndate: " + email.getSentDate()
                    + "\nhostname: " + email.getHostName() + "\nport: "
                    + email.getSmtpPort() + "\nfrom: "
                    + email.getFromAddress().toString() + "\nto: " + to
                    + "\nsubject: " + email.getSubject() + "\nmsg: " + msg);
        }
    }
}
