/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité UserAccount.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class UserAccountDAOAbstract<E extends UserAccount> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)UserAccount.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.PersonList> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.PersonList.class)
                            .findAllByProperties("owner", entity);
                    for (org.chorem.pollen.business.persistence.PersonList item : list) {
                        item.setOwner(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.PollAccount> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.PollAccount.class)
                            .findAllByProperties("userAccount", entity);
                    for (org.chorem.pollen.business.persistence.PollAccount item : list) {
                        item.setUserAccount(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut login
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * login le paramètre
     * @param v la valeur que doit avoir login
     * @return un element ou null
     */
    public E findByLogin(java.lang.String v) throws TopiaException {
        E result = findByProperty("login", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * login le paramètre
     * @param v la valeur que doit avoir login
     * @return une liste
     */
    public List<E> findAllByLogin(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("login", v);
        return result;
    }
    /**
     * Recherche sur l'attribut password
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * password le paramètre
     * @param v la valeur que doit avoir password
     * @return un element ou null
     */
    public E findByPassword(java.lang.String v) throws TopiaException {
        E result = findByProperty("password", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * password le paramètre
     * @param v la valeur que doit avoir password
     * @return une liste
     */
    public List<E> findAllByPassword(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("password", v);
        return result;
    }
    /**
     * Recherche sur l'attribut firstName
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * firstName le paramètre
     * @param v la valeur que doit avoir firstName
     * @return un element ou null
     */
    public E findByFirstName(java.lang.String v) throws TopiaException {
        E result = findByProperty("firstName", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * firstName le paramètre
     * @param v la valeur que doit avoir firstName
     * @return une liste
     */
    public List<E> findAllByFirstName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("firstName", v);
        return result;
    }
    /**
     * Recherche sur l'attribut lastName
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * lastName le paramètre
     * @param v la valeur que doit avoir lastName
     * @return un element ou null
     */
    public E findByLastName(java.lang.String v) throws TopiaException {
        E result = findByProperty("lastName", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * lastName le paramètre
     * @param v la valeur que doit avoir lastName
     * @return une liste
     */
    public List<E> findAllByLastName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("lastName", v);
        return result;
    }
    /**
     * Recherche sur l'attribut administrator
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * administrator le paramètre
     * @param v la valeur que doit avoir administrator
     * @return un element ou null
     */
    public E findByAdministrator(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("administrator", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * administrator le paramètre
     * @param v la valeur que doit avoir administrator
     * @return une liste
     */
    public List<E> findAllByAdministrator(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("administrator", v);
        return result;
    }
    /**
     * Recherche sur l'attribut langage
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * langage le paramètre
     * @param v la valeur que doit avoir langage
     * @return un element ou null
     */
    public E findByLangage(java.lang.String v) throws TopiaException {
        E result = findByProperty("langage", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * langage le paramètre
     * @param v la valeur que doit avoir langage
     * @return une liste
     */
    public List<E> findAllByLangage(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("langage", v);
        return result;
    }
    /**
     * Recherche sur l'attribut email
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return un element ou null
     */
    public E findByEmail(java.lang.String v) throws TopiaException {
        E result = findByProperty("email", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * email le paramètre
     * @param v la valeur que doit avoir email
     * @return une liste
     */
    public List<E> findAllByEmail(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("email", v);
        return result;
    }
    /**
     * Recherche sur l'attribut favoriteList
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * favoriteList contient le paramètre
     * @param v la valeur que doit contenir favoriteList
     * @return un element ou null
     */
    public E findContainsFavoriteList(org.chorem.pollen.business.persistence.PersonList ... v) throws TopiaException {
        E result = findContainsProperties("favoriteList", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * favoriteList contient le paramètre
     * @param v la valeur que doit contenir favoriteList
     * @return une liste
     */
    public List<E> findAllContainsFavoriteList(org.chorem.pollen.business.persistence.PersonList ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("favoriteList", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut pollAccount
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return un element ou null
     */
    public E findContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        E result = findContainsProperties("pollAccount", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return une liste
     */
    public List<E> findAllContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("pollAccount", Arrays.asList(v));
        return results;
    }

} // UserAccountDAOAbstract
