/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link PollAccount}.
 */
public abstract class PollAccountAbstract extends TopiaEntityAbstract implements PollAccount {

    public String votingId;

    public String email;

    public List<PersonToList> votingListPersonToList;

    public List<Poll> pollsCreated;

    public List<Comment> comment;

    public List<Vote> vote;

    public PersonList personList;

    public UserAccount userAccount;

    /**
     * Constructeur de PollAccountAbstract par défaut.
     */
    public PollAccountAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PollAccount.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PollAccount.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "votingId", String.class, votingId);
        visitor.visit(this, "email", String.class, email);
        visitor.visit(this, "votingListPersonToList", java.util.List.class, PersonToList.class, votingListPersonToList);
        visitor.visit(this, "pollsCreated", List.class, Poll.class, pollsCreated);
        visitor.visit(this, "comment", List.class, Comment.class, comment);
        visitor.visit(this, "vote", List.class, Vote.class, vote);
        visitor.visit(this, "personList", PersonList.class, personList);
        visitor.visit(this, "userAccount", UserAccount.class, userAccount);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        tmp.addAll(((TopiaContextImplementor)getTopiaContext())
            .getDAO(PersonToList.class)
            .findAllByProperties("pollAccount", this));

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see PollAccount#setVotingId(String)
     */
    @Override
    public void setVotingId(String value) {
        String _oldValue = this.votingId;
        fireOnPreWrite("votingId", _oldValue, value);
        this.votingId = value;
        fireOnPostWrite("votingId", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PollAccount#getVotingId()
     */
    @Override
    public String getVotingId() {
        fireOnPreRead("votingId", votingId);
        String result = this.votingId;
        fireOnPostRead("votingId", votingId);
        return result;
    }

    /* (non-Javadoc)
     * @see PollAccount#setEmail(String)
     */
    @Override
    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        fireOnPostWrite("email", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PollAccount#getEmail()
     */
    @Override
    public String getEmail() {
        fireOnPreRead("email", email);
        String result = this.email;
        fireOnPostRead("email", email);
        return result;
    }

    /* (non-Javadoc)
     * @see PollAccount#addVotingListPersonToList(PersonToList)
     */
    @Override
    public void addVotingListPersonToList(PersonToList value) {
        fireOnPreWrite("votingListPersonToList", null, value);
        if (this.votingListPersonToList == null) {
            this.votingListPersonToList = new ArrayList<PersonToList>();
        }
        value.setPollAccount(this);
        this.votingListPersonToList.add(value);
        fireOnPostWrite("votingListPersonToList", this.votingListPersonToList.size(), null, value);
    }

    /* (non-Javadoc)
     * @see PollAccount#getVotingListByTopiaId(String)
     */
    @Override
    public PersonToList getVotingListPersonToListByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(votingListPersonToList, topiaId);
    }

    /* (non-Javadoc)
     * @see PollAccount#addAllVotingListPersonToList(List<PersonToList>()
     */
    @Override
    public void addAllVotingListPersonToList(List<PersonToList> values) {
        if (values == null) {
            return;
        }
        for (PersonToList item : values) {
            addVotingListPersonToList(item);
        }
    }

    /* (non-Javadoc)
     * @see PollAccount#setVotingListPersonToList(List<PersonToList>()
     */
    @Override
    public void setVotingListPersonToList(List<PersonToList> values) {
//        clearVotingListPersonToList();
//        addAllVotingListPersonToList(values);
// FIXME
        List<PersonToList> _oldValue = votingListPersonToList;
        fireOnPreWrite("votingListPersonToList", _oldValue, values);
        votingListPersonToList = values;
        fireOnPostWrite("votingListPersonToList", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see PollAccount#removeVotingListPersonToList(PersonToList)
     */
    @Override
    public void removeVotingListPersonToList(PersonToList value) {
        fireOnPreWrite("votingListPersonToList", value, null);
        if ((this.votingListPersonToList == null) || (!this.votingListPersonToList.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPollAccount(null);
        fireOnPostWrite("votingListPersonToList", this.votingListPersonToList.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see PollAccount#clearVotingListPersonToList()
     */
    @Override
    public void clearVotingListPersonToList() {
        if (this.votingListPersonToList == null) {
            return;
        }
        for (PersonToList item : this.votingListPersonToList) {
            item.setPollAccount(null);
        }
        List<PersonToList> _oldValue = new ArrayList<PersonToList>(this.votingListPersonToList);
        fireOnPreWrite("votingListPersonToList", _oldValue, null);
        this.votingListPersonToList.clear();
        fireOnPostWrite("votingListPersonToList", _oldValue, null);
    }

    /* (non-Javadoc)
     * @see PollAccount#getVotingListPersonToList()
     */
    @Override
    public List<PersonToList> getVotingListPersonToList() {
        return votingListPersonToList;
    }

    /* (non-Javadoc)
     * @see PollAccount#getVotingListPersonToList(VotingList)
     */
    @Override
    public PersonToList getVotingListPersonToList(VotingList value) {
        if (value == null || votingListPersonToList == null) {
            return null;
        }
        for (PersonToList item : votingListPersonToList) {
            if (value.equals(item.getVotingList())) {
                return item;
            }
        }
        return null;
    }

    /* (non-Javadoc)
     * @see PollAccount#sizeVotingListPersonToList()
     */
    @Override
    public int sizeVotingListPersonToList() {
        if (votingListPersonToList == null) {
            return 0;
        }
        return votingListPersonToList.size();
    }

    /* (non-Javadoc)
     * @see PollAccount#isVotingListPersonToListEmpty()
     */
    @Override
    public boolean isVotingListPersonToListEmpty() {
        int size = sizeVotingListPersonToList();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see PollAccount#addPollsCreated(Poll)
     */
    @Override
    public void addPollsCreated(Poll pollsCreated) {
        fireOnPreWrite("pollsCreated", null, pollsCreated);
        if (this.pollsCreated == null) {
            this.pollsCreated = new ArrayList<Poll>();
        }
        pollsCreated.setCreator(this);
        this.pollsCreated.add(pollsCreated);
        fireOnPostWrite("pollsCreated", this.pollsCreated.size(), null, pollsCreated);
    }

    /* (non-Javadoc)
     * @see PollAccount#addAllPollsCreated(List<Poll>)
     */
    @Override
    public void addAllPollsCreated(List<Poll> values) {
        if (values == null) {
            return;
        }
        for (Poll item : values) {
            addPollsCreated(item);
        }
    }

    /* (non-Javadoc)
     * @see PollAccount#getPollsCreatedByTopiaId(String)
     */
    @Override
    public Poll getPollsCreatedByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(pollsCreated, topiaId);
    }
 
    /* (non-Javadoc)
     * @see PollAccount#setPollsCreated(List<Poll>)
     */
    @Override
    public void setPollsCreated(List<Poll> values) {
        List<Poll> _oldValue = pollsCreated;
        fireOnPreWrite("pollsCreated", _oldValue, values);
        pollsCreated = values;
        fireOnPostWrite("pollsCreated", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see PollAccount#removePollsCreated(Poll)
     */
    @Override
    public void removePollsCreated(Poll value) {
        fireOnPreWrite("pollsCreated", value, null);
        if ((this.pollsCreated == null) || (!this.pollsCreated.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setCreator(null);
        fireOnPostWrite("pollsCreated", this.pollsCreated.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see PollAccount#clearPollsCreated()
     */
    @Override
    public void clearPollsCreated() {
        if (this.pollsCreated == null) {
            return;
        }
        for (Poll item : this.pollsCreated) {
            item.setCreator(null);
        }
        List<Poll> _oldValue = new ArrayList<Poll>(this.pollsCreated);
        fireOnPreWrite("pollsCreated", _oldValue, this.pollsCreated);
        this.pollsCreated.clear();
        fireOnPostWrite("pollsCreated", _oldValue, this.pollsCreated);
    }

    /* (non-Javadoc)
     * @see PollAccount#getPollsCreated()
     */
    @Override
    public List<Poll> getPollsCreated() {
        return pollsCreated;
    }

    /* (non-Javadoc)
     * @see PollAccount#sizePollsCreated()
     */
    @Override
    public int sizePollsCreated() {
        if (pollsCreated == null) {
            return 0;
        }
        return pollsCreated.size();
    }

    /* (non-Javadoc)
     * @see PollAccount#isPollsCreatedEmpty()
     */
    @Override
    public boolean isPollsCreatedEmpty() {
        int size = sizePollsCreated();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see PollAccount#addComment(Comment)
     */
    @Override
    public void addComment(Comment comment) {
        fireOnPreWrite("comment", null, comment);
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        comment.setPollAccount(this);
        this.comment.add(comment);
        fireOnPostWrite("comment", this.comment.size(), null, comment);
    }

    /* (non-Javadoc)
     * @see PollAccount#addAllComment(List<Comment>)
     */
    @Override
    public void addAllComment(List<Comment> values) {
        if (values == null) {
            return;
        }
        for (Comment item : values) {
            addComment(item);
        }
    }

    /* (non-Javadoc)
     * @see PollAccount#getCommentByTopiaId(String)
     */
    @Override
    public Comment getCommentByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(comment, topiaId);
    }
 
    /* (non-Javadoc)
     * @see PollAccount#setComment(List<Comment>)
     */
    @Override
    public void setComment(List<Comment> values) {
        List<Comment> _oldValue = comment;
        fireOnPreWrite("comment", _oldValue, values);
        comment = values;
        fireOnPostWrite("comment", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see PollAccount#removeComment(Comment)
     */
    @Override
    public void removeComment(Comment value) {
        fireOnPreWrite("comment", value, null);
        if ((this.comment == null) || (!this.comment.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPollAccount(null);
        fireOnPostWrite("comment", this.comment.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see PollAccount#clearComment()
     */
    @Override
    public void clearComment() {
        if (this.comment == null) {
            return;
        }
        for (Comment item : this.comment) {
            item.setPollAccount(null);
        }
        List<Comment> _oldValue = new ArrayList<Comment>(this.comment);
        fireOnPreWrite("comment", _oldValue, this.comment);
        this.comment.clear();
        fireOnPostWrite("comment", _oldValue, this.comment);
    }

    /* (non-Javadoc)
     * @see PollAccount#getComment()
     */
    @Override
    public List<Comment> getComment() {
        return comment;
    }

    /* (non-Javadoc)
     * @see PollAccount#sizeComment()
     */
    @Override
    public int sizeComment() {
        if (comment == null) {
            return 0;
        }
        return comment.size();
    }

    /* (non-Javadoc)
     * @see PollAccount#isCommentEmpty()
     */
    @Override
    public boolean isCommentEmpty() {
        int size = sizeComment();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see PollAccount#addVote(Vote)
     */
    @Override
    public void addVote(Vote vote) {
        fireOnPreWrite("vote", null, vote);
        if (this.vote == null) {
            this.vote = new ArrayList<Vote>();
        }
        vote.setPollAccount(this);
        this.vote.add(vote);
        fireOnPostWrite("vote", this.vote.size(), null, vote);
    }

    /* (non-Javadoc)
     * @see PollAccount#addAllVote(List<Vote>)
     */
    @Override
    public void addAllVote(List<Vote> values) {
        if (values == null) {
            return;
        }
        for (Vote item : values) {
            addVote(item);
        }
    }

    /* (non-Javadoc)
     * @see PollAccount#getVoteByTopiaId(String)
     */
    @Override
    public Vote getVoteByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(vote, topiaId);
    }
 
    /* (non-Javadoc)
     * @see PollAccount#setVote(List<Vote>)
     */
    @Override
    public void setVote(List<Vote> values) {
        List<Vote> _oldValue = vote;
        fireOnPreWrite("vote", _oldValue, values);
        vote = values;
        fireOnPostWrite("vote", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see PollAccount#removeVote(Vote)
     */
    @Override
    public void removeVote(Vote value) {
        fireOnPreWrite("vote", value, null);
        if ((this.vote == null) || (!this.vote.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPollAccount(null);
        fireOnPostWrite("vote", this.vote.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see PollAccount#clearVote()
     */
    @Override
    public void clearVote() {
        if (this.vote == null) {
            return;
        }
        for (Vote item : this.vote) {
            item.setPollAccount(null);
        }
        List<Vote> _oldValue = new ArrayList<Vote>(this.vote);
        fireOnPreWrite("vote", _oldValue, this.vote);
        this.vote.clear();
        fireOnPostWrite("vote", _oldValue, this.vote);
    }

    /* (non-Javadoc)
     * @see PollAccount#getVote()
     */
    @Override
    public List<Vote> getVote() {
        return vote;
    }

    /* (non-Javadoc)
     * @see PollAccount#sizeVote()
     */
    @Override
    public int sizeVote() {
        if (vote == null) {
            return 0;
        }
        return vote.size();
    }

    /* (non-Javadoc)
     * @see PollAccount#isVoteEmpty()
     */
    @Override
    public boolean isVoteEmpty() {
        int size = sizeVote();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see PollAccount#setPersonList(PersonList)
     */
    @Override
    public void setPersonList(PersonList value) {
        PersonList _oldValue = this.personList;
        fireOnPreWrite("personList", _oldValue, value);
        this.personList = value;
        fireOnPostWrite("personList", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PollAccount#getPersonList()
     */
    @Override
    public PersonList getPersonList() {
        fireOnPreRead("personList", personList);
        PersonList result = this.personList;
        fireOnPostRead("personList", personList);
        return result;
    }

    /* (non-Javadoc)
     * @see PollAccount#setUserAccount(UserAccount)
     */
    @Override
    public void setUserAccount(UserAccount value) {
        UserAccount _oldValue = this.userAccount;
        fireOnPreWrite("userAccount", _oldValue, value);
        this.userAccount = value;
        fireOnPostWrite("userAccount", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PollAccount#getUserAccount()
     */
    @Override
    public UserAccount getUserAccount() {
        fireOnPreRead("userAccount", userAccount);
        UserAccount result = this.userAccount;
        fireOnPostRead("userAccount", userAccount);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("votingId", this.votingId).
            append("email", this.email).
         toString();
        return result;
    }
        
} //PollAccountAbstract
