/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;

/**
 * Classe DTO représentant un sondage.
 *
 * @author amine
 * @author rannou
 * @version $Id: PollDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PollDTO implements Serializable {

    private String id = "";

    private String pollId = "";

    private String title = "";

    private String description = "";

    private Date beginDate = null;

    private Date endDate = null;

    private Date beginChoiceDate = null;

    private int maxChoiceNb = 0;

    private boolean closed = false;

    private boolean choiceAddAllowed = false;

    private boolean anonymousVoteAllowed = false;

    private boolean anonymous = false;

    private boolean publicResults = false;

    private boolean continuousResults = false;

    private PollType pollType = null;

    private VoteCountingType voteCounting = null;

    private ChoiceType choiceType = ChoiceType.TEXT;

    private String userId = "";

    private String creatorId = "";

    private String creatorEmail = "";

    private List<CommentDTO> commentDTOs = new ArrayList<CommentDTO>();

    private List<VotingListDTO> votingListDTOs = new ArrayList<VotingListDTO>();

    private List<VoteDTO> voteDTOs = new ArrayList<VoteDTO>();

    private List<PreventRuleDTO> preventRuleDTOs = new ArrayList<PreventRuleDTO>();

    private List<ChoiceDTO> choiceDTOs = new ArrayList<ChoiceDTO>();

    private List<ResultDTO> resultDTOs = new ArrayList<ResultDTO>();

    public PollDTO() {

    }

    public PollDTO(String id) {
        this.id = id;
    }

    public PollDTO(String title, String creatorId, ChoiceType choiceType,
            PollType pollType, VoteCountingType voteCounting) {
        super();
        this.title = title;
        this.pollType = pollType;
        this.creatorId = creatorId;
        this.choiceType = choiceType;
        this.voteCounting = voteCounting;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getBeginChoiceDate() {
        return beginChoiceDate;
    }

    public void setBeginChoiceDate(Date beginChoiceDate) {
        this.beginChoiceDate = beginChoiceDate;
    }

    public int getMaxChoiceNb() {
        return maxChoiceNb;
    }

    public void setMaxChoiceNb(int maxChoiceNb) {
        this.maxChoiceNb = maxChoiceNb;
    }

    public boolean isClosed() {
        return closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isChoiceAddAllowed() {
        return choiceAddAllowed;
    }

    public void setChoiceAddAllowed(boolean choiceAddAllowed) {
        this.choiceAddAllowed = choiceAddAllowed;
    }

    public boolean isAnonymousVoteAllowed() {
        return anonymousVoteAllowed;
    }

    public void setAnonymousVoteAllowed(boolean anonymousVoteAllowed) {
        this.anonymousVoteAllowed = anonymousVoteAllowed;
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isPublicResults() {
        return publicResults;
    }

    public void setPublicResults(boolean publicResults) {
        this.publicResults = publicResults;
    }

    public boolean isContinuousResults() {
        return continuousResults;
    }

    public void setContinuousResults(boolean continuousResults) {
        this.continuousResults = continuousResults;
    }

    public PollType getPollType() {
        return pollType;
    }

    public void setPollType(PollType pollType) {
        this.pollType = pollType;
    }

    public VoteCountingType getVoteCounting() {
        return voteCounting;
    }

    public void setVoteCounting(VoteCountingType voteCounting) {
        this.voteCounting = voteCounting;
    }

    public ChoiceType getChoiceType() {
        return choiceType;
    }

    public void setChoiceType(ChoiceType choiceType) {
        this.choiceType = choiceType;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorEmail() {
        return creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public List<CommentDTO> getCommentDTOs() {
        return commentDTOs;
    }

    public void setCommentDTOs(List<CommentDTO> commentDTOs) {
        this.commentDTOs = commentDTOs;
    }

    public List<VotingListDTO> getVotingListDTOs() {
        return votingListDTOs;
    }

    public void setVotingListDTOs(List<VotingListDTO> votingListDTOs) {
        this.votingListDTOs = votingListDTOs;
    }

    public List<VoteDTO> getVoteDTOs() {
        return voteDTOs;
    }

    public void setVoteDTOs(List<VoteDTO> voteDTOs) {
        this.voteDTOs = voteDTOs;
    }

    public List<PreventRuleDTO> getPreventRuleDTOs() {
        return preventRuleDTOs;
    }

    public void setPreventRuleDTOs(List<PreventRuleDTO> preventRuleDTOs) {
        this.preventRuleDTOs = preventRuleDTOs;
    }

    public List<ChoiceDTO> getChoiceDTOs() {
        return choiceDTOs;
    }

    public void setChoiceDTOs(List<ChoiceDTO> choiceDTOs) {
        this.choiceDTOs = choiceDTOs;
    }

    public List<ResultDTO> getResultDTOs() {
        return resultDTOs;
    }

    public void setResultDTOs(List<ResultDTO> resultDTOs) {
        this.resultDTOs = resultDTOs;
    }

}