/*
 * #%L
 * bow
 * 
 * $Id: RegisterAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/RegisterAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowMail;
import org.chorem.bow.User;
import org.chorem.bow.UserImpl;
import org.chorem.bow.BowInit;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Enregistre un nouvel utilisateur
 *
 * @author poussin
 */
public class RegisterAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 2204772861770399542L;
    protected String email;
    protected String password;
    protected String repeatPassword;
    protected HttpServletRequest request;
    
    /**
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * @param email the email to set
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the repeatPassword
     */
    public String getRepeatPassword() {
        return repeatPassword;
    }

    /**
     * @param repeatPassword the repeatPassword to set
     */
    public void setRepeatPassword(String repeatPassword) {
        this.repeatPassword = repeatPassword;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }
    
    protected boolean checkRegister(String passwordMD5) {
	if (email != null && passwordMD5 != null) {
	    if (!email.isEmpty() && !passwordMD5.equals(StringUtil.encodeMD5(""))) {
		WikittyProxy proxy = getBowProxy();
		Criteria criteria = Search.query().eq(User.FQ_FIELD_USER_EMAIL, email).criteria(); //Retrieves user by user name (email)

		if (proxy.findByCriteria(User.class, criteria) == null) {
		    return false;
		}
		//FIXME : message d'erreur mais return true ???
		addFieldError("email", getText(n_("bow.register.emailAldyUsed")));
		return true;
	    }
	}
	//FIXME : message d'erreur mais return true ???
	//request.setAttribute("errorMsgUser", "Email and password must be correctly filled");
	return true;
    }

    public String execute() {
        if (email != null) {
            email = email.trim();
            if (password != null) {
                if (!password.equals(repeatPassword)) {
                    addActionError(getText(n_("bow.register.pwdDontMatch")));
                    return INPUT;
                }
                String md5 = StringUtil.encodeMD5(password);

                if (!checkRegister(md5)) {
                    WikittyProxy proxy = getBowProxy();
                    UserImpl newUser = new UserImpl();
                    newUser.setPassword(md5);
                    newUser.setEmail(email);
                    User login = proxy.store(newUser); //Stores the new user

                    if (login == null) {
                        addFieldError("email", getText(n_("bow.register.invalidLogin")));
                    } else {
                        getBowSession().setUser(login);
                        BowInit.initHomePage(request, login);
                        try {
                            String mailContent;

                            mailContent = getText(n_("bow.register.mailHi")) + ",\n\n" + getText(n_("bow.register.mailPwd")) + ": " + password + "\n\n" + getText(n_("bow.register.mailEmail")) + ": " + email + "\n\n";
                            BowMail.sendMail(email, getText(n_("bow.register.mailSubject")), mailContent);
                        } catch (AddressException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (MessagingException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                        return SUCCESS;
                    }
                }
            }
        }
        return INPUT;
    }
}
