/*
 * #%L
 * bow
 * 
 * $Id: OrderAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/OrderAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkActions;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Permet de modifie l'ordre de tri des bookmarks
 * TODO poussin 20110211 cette action n'est pas vraiment pertinente et devrait
 * etre des options de l'action de recherche
 *
 * @author poussin
 */
public class OrderAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 203690999710176818L;
    protected String type;
    protected String searchLine;
    protected HttpServletRequest request;
    
    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

    public String execute() {
        User user = getBowSession().getUser();
        Criteria baseCriteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);

        if (type != null && baseCriteria != null && !type.isEmpty()) {
            WikittyProxy proxy = getBowProxy();
            PagedResult<Bookmark> result = null;

            if (type.equals("ascName")) {
                Criteria criteria = baseCriteria.addSortAscending(
                        Bookmark.FQ_FIELD_BOOKMARK_DESCRIPTION);
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("ascDate")) {
                Criteria criteria = baseCriteria.addSortAscending(
                        Bookmark.FQ_FIELD_BOOKMARK_DATE);
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("ascClick")) {
                Criteria criteria = baseCriteria.addSortAscending(
                        Bookmark.FQ_FIELD_BOOKMARK_CLICK);
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("descName")) {
                Criteria criteria = baseCriteria.addSortDescending(
                        Bookmark.FQ_FIELD_BOOKMARK_DESCRIPTION);
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("descDate")) {
                Criteria criteria = baseCriteria.addSortDescending(
                        Bookmark.FQ_FIELD_BOOKMARK_DATE);
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("descClick")) {
                Criteria criteria = baseCriteria.addSortDescending(
                        Bookmark.FQ_FIELD_BOOKMARK_CLICK);
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            }
            BookmarkActions bookmarkActions =
                    BookmarkUtils.createBookmarkActions(request, result, searchLine);
            request.setAttribute("bookmarkActions", bookmarkActions);
        }
        return SUCCESS;
    }
}
