/*
 * #%L
 * bow
 * 
 * $Id: OpenSearchSuggestionAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/OpenSearchSuggestionAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.Bookmark;
import org.chorem.bow.OpenSearchActions;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Retourne les suggestions pour l'opensearch en fonction de ce qui a ete deja
 * saisie
 * 
 * @author poussin
 */
public class OpenSearchSuggestionAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 3973618635494129146L;
    protected String searchLine;
    protected HttpServletRequest request;

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

    public String execute() {
	User user = getBowSession().getUser();

	if (searchLine != null) {
	    OpenSearchActions openSearchActions = new OpenSearchActions();
	    WikittyProxy proxy = getBowProxy();
	    String[] words = searchLine.split("\\s+");
	    List<String> searchLineList = new ArrayList<String>(Arrays.asList(words));

	    if (searchLine.charAt(searchLine.length() - 1) == ' ') {
		searchLineList.add(""); //If the user doesn't type anything, we have to propose suggestions
	    }
	    Criteria criteria;

	    if (searchLineList.size() > 1) {
		List<String> cpy = new ArrayList<String>(searchLineList);
		cpy.remove(cpy.size() - 1);
		criteria = Search.query().eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail()).
		eq(Bookmark.FQ_FIELD_BOOKMARK_TAGS, cpy).criteria().addFacetField(Bookmark.FQ_FIELD_BOOKMARK_TAGS);
	    } else {
		criteria = Search.query().eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail()).
		criteria().addFacetField(Bookmark.FQ_FIELD_BOOKMARK_TAGS);
	    }
	    PagedResult<Bookmark> result = proxy.findAllByCriteria(Bookmark.class, criteria);
	    List<Bookmark> bookList = result.getAll();
	    List<FacetTopic> topics = result.getTopic(Bookmark.FQ_FIELD_BOOKMARK_TAGS);

	    openSearchActions.setBookmarkList(bookList);
	    openSearchActions.setSuggestionList(topics);
	    openSearchActions.findSuggestions(searchLineList);
	    request.setAttribute("openSearchAction", openSearchActions);
	}
	return SUCCESS;
    }
}