/*
 * #%L
 * bow
 * 
 * $Id: OpenSearchResultAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/OpenSearchResultAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkActions;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowUtils;
import org.chorem.bow.Preference;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Traite toutes les demandes faite via l'opensearch
 * a:, :, t:, ...
 *
 * @author poussin
 */
public class OpenSearchResultAction extends BowBaseAction implements ServletRequestAware, ServletResponseAware {
    private static final long serialVersionUID = -1691325797986483856L;
    protected String searchLine;
    protected String token;
    protected String redirectTo;
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the token
     */
    public String getToken() {
        return token;
    }

    /**
     * @param token the token to set
     */
    public void setToken(String token) {
        this.token = token;
    }

    /**
     * @return the redirectTo
     */
    public String getRedirectTo() {
        return redirectTo;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

    @Override
    public void setServletResponse(HttpServletResponse response) {
	this.response = response;
    }

    public String execute() {
        User user = getBowSession().getUser();
        if (searchLine != null && searchLine.matches("^http://[^ ]*")) {
            redirectTo = BowUtils.redirectTo(searchLine, null);
        } else if (searchLine != null
                && (searchLine.startsWith(":") || searchLine.startsWith("t:"))) {
            //On fait une recherche sur les tags

            int index = searchLine.indexOf(":");
            searchLine = searchLine.substring(index + 1); //Suppresses first ":"

            WikittyProxy proxy = getBowProxy();
            Criteria criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);
            criteria = criteria.addSortDescending(Bookmark.FQ_FIELD_BOOKMARK_CLICK);
            PagedResult<Bookmark> result = proxy.findAllByCriteria(Bookmark.class, criteria); //Retrieves bookmarks by search
            BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, searchLine);
            request.setAttribute("bookmarkActions", bookmarkActions);
            request.setAttribute("token", token);
            redirectTo = BowUtils.redirectTo(searchLine, null);
        } else if (searchLine != null && searchLine.startsWith("f:")) {
            // recherche fulltext dans bow
            String fullText = searchLine.substring(2);
            WikittyProxy proxy = getBowProxy();
            Criteria criteria;
            if (!fullText.isEmpty()) {
                criteria = Search.query().keyword(fullText).
                        eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail()).criteria().
                        addFacetField(Bookmark.FQ_FIELD_BOOKMARK_TAGS);
            } else {
                criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, null);
            }
            PagedResult<Bookmark> result = proxy.findAllByCriteria(Bookmark.class, criteria);
            BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, null);
            request.setAttribute("bookmarkActions", bookmarkActions);
            request.setAttribute("token", token);
            redirectTo = BowUtils.redirectTo(searchLine, null);
        } else if (searchLine != null && searchLine.startsWith("a:")) {
            // on redirige vers l'alias demande
            searchLine = searchLine.substring(2);
            redirectTo = BowConfig.getInstance().getAliasUrl() + searchLine;
        } else {
            // on fait une recherche sur le moteur de recherche configure
            WikittyProxy proxy = getBowProxy();
            Preference pref = proxy.restore(Preference.class, user.getWikittyId());

            String searchEngineURL = pref.getSearchEngineUrlResults();
            if (searchEngineURL == null || "".equals(searchEngineURL)) {
                BowConfig config = BowConfig.getInstance();
                searchEngineURL = config.getSearchEngine();
            }
            searchEngineURL = searchEngineURL.replace("{searchTerms}", searchLine);
            searchEngineURL = response.encodeRedirectURL(searchEngineURL);
            redirectTo = searchEngineURL;
        }
        return SUCCESS;
    }
}
