/*
 * #%L
 * bow
 * 
 * $Id: LoginAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/LoginAction.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.bow.action;

import java.security.NoSuchAlgorithmException;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.User;
import org.chorem.bow.BowInit;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * authentifie l'utilisateur et place son objet User dans la bow session
 * 
 * @author poussin
 */
public class LoginAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 6891064800288772246L;
    protected String email;
    protected String password;
    protected HttpServletRequest servletRequest;

    public String getEmail() {
	return email;
    }
    
    public void setEmail(String email) {
	this.email = email;
    }
    
    public String getPassword() {
	return password;
    }
    
    public void setPassword(String password) {
	this.password = password;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.servletRequest = request;
    }
    
    protected User checkLogin(String email, String password) throws NoSuchAlgorithmException {
	if (email != null && password != null) {
	    if (!email.isEmpty() && !password.equals(StringUtil.encodeMD5(""))) {
		WikittyProxy proxy = getBowProxy();
		Criteria criteria = Search.query().eq(User.FQ_FIELD_USER_EMAIL, email).
		eq(User.FQ_FIELD_USER_PASSWORD, password).criteria();
		User user = proxy.findByCriteria(User.class, criteria);

		if (user == null) {
		    addActionError(getText(n_("bow.login.authenticationFailure")));
		}
		return user;
	    }
	}
	return null;
    }
    
    public String execute() {
        if (email != null) {
            email = email.trim();

            if (password != null) {
                String md5 = StringUtil.encodeMD5(password);
                User user;

                try {
                    user = checkLogin(email, md5);
                } catch (NoSuchAlgorithmException e) {
                    return ERROR;
                }
                if (user != null) {
                    getBowSession().setUser(user);
                    BowInit.initHomePage(servletRequest, user);
                    return SUCCESS;
                }
            }
        }
        return INPUT;
    }
}