/*
 * #%L
 * bow
 * 
 * $Id: ImportBookmarksAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/ImportBookmarksAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowInit;
import org.chorem.bow.BowSearch;
import org.chorem.bow.BowUtils;
import org.chorem.bow.ImportHelper;
import org.chorem.bow.User;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;

import static org.nuiton.i18n.I18n.n_;

/**
 * Import un bookmark HTML
 * 
 * @author poussin
 */
public class ImportBookmarksAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -5962680416570797028L;
    protected File upfile;
    protected String upfileContentType;
    protected String upfileFileName;
    protected String searchLine;
    protected String fullTextLine;
    protected String redirectTo;
    protected HttpServletRequest request;

    /**
     * @return the upfile
     */
    public File getUpfile() {
        return upfile;
    }

    /**
     * @param upfile the upfile to set
     */
    public void setUpfile(File upfile) {
        this.upfile = upfile;
    }

    /**
     * @return the upfileContentType
     */
    public String getUpfileContentType() {
        return upfileContentType;
    }

    /**
     * @param upfileContentType the upfileContentType to set
     */
    public void setUpfileContentType(String upfileContentType) {
        this.upfileContentType = upfileContentType;
    }

    /**
     * @return the upfileFileName
     */
    public String getUpfileFileName() {
        return upfileFileName;
    }

    /**
     * @param upfileFileName the upfileFileName to set
     */
    public void setUpfileFileName(String upfileFileName) {
        this.upfileFileName = upfileFileName;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    /**
     * @return the redirectTo
     */
    public String getRedirectTo() {
        return redirectTo;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

//    protected void createImportExtension(List<Bookmark> bookmarks) {
//	if (bookmarks != null && !bookmarks.isEmpty()) {
//	    WikittyProxy proxy = getBowProxy();
//	    List<String> ids = new ArrayList<String>();
//
//	    for (Bookmark bookmark : bookmarks) {
//		String id = bookmark.getWikittyId();
//		ids.add(id);
//	    }
//	    Date date = new Date();
//	    List<Import> imports = proxy.restore(Import.class, ids);
//
//	    for (Import imp : imports) {
//		imp.setDate(date);
//	    }
//	    proxy.store(imports);
//	}
//    }

    protected void parseHtmlToBookmarks(NodeList list, User user, Date date,
            List<Bookmark> bookmarks, List<String> tagList)
    throws ParserException {
	if (list != null) {
	    boolean isFolder = false;
	    SimpleNodeIterator it = list.elements();

	    while (it.hasMoreNodes()) {
		Node node = it.nextNode();
		String plainText = node.toPlainTextString(); //The text between two heads ==> <toto>plainText</toto>
		String text = node.getText(); //The text in the head ==> <text></toto>

		if (text != null && text.startsWith("H3")) { // H3 = folder
		    if (plainText != null && !plainText.isEmpty()) {
			tagList.add(plainText); //Adds the folder name to the tagList
			isFolder = true;
		    }
		} else if (text != null && text.startsWith("A HREF")) { // HREF = new bookmarks
		    Bookmark bookmark = BookmarkUtils.createBookmarkFromHtml(text, plainText, user);
            Wikitty w = getBowProxy().getWikitty(bookmark);
            ImportHelper.addExtension(w);
            ImportHelper.setDate(w, date);
		    BookmarkUtils.addTagsToBookmark(tagList, bookmark);

		    if (bookmark != null) {
			bookmarks.add(bookmark);
		    }
		}
		NodeList children = node.getChildren();

		if (children != null) {
		    parseHtmlToBookmarks(children, user, date, bookmarks, tagList); //If there is an under node = recursion
		}
	    }
	    if (isFolder) { //If we find a folder, we have to remove it
		int index = tagList.size() - 1;

		if (index > -1) {
		    tagList.remove(index);
		}
	    }
	}
    }

    public String execute() {
	User user = getBowSession().getUser();
	
	if (upfile != null) {
//	    try {
//		List<?> lines = FileUtils.readLines(upfile);
//		String content = "";
//
//		for (Object line : lines) {
//		    content += (String)line;
//		}
		WikittyProxy proxy = getBowProxy();

		try {
            URL url = upfile.toURI().toURL();
		    Parser parser = new Parser(url.openConnection());
		    NodeList list = parser.parse(null);
		    List<Bookmark> bookmarks = new ArrayList<Bookmark>();
		    parseHtmlToBookmarks(list, user, new Date(), bookmarks, new ArrayList<String>());
		    bookmarks = proxy.store(bookmarks);
//		    createImportExtension(bookmarks);
		    redirectTo = BowUtils.redirectTo(searchLine, fullTextLine);
		    if (searchLine == null || searchLine.isEmpty()) {
			BowInit.initHomePage(request, user);
			return SUCCESS;
		    } else {
			try {
			    BowSearch.search(request, user);
			} catch (IOException e1) {
			    // TODO Auto-generated catch block
			    e1.printStackTrace();
			} catch (ServletException e1) {
			    // TODO Auto-generated catch block
			    e1.printStackTrace();
			}
			return SUCCESS;
		    }
		} catch (ParserException e) {
		    request.setAttribute("errorMsgUser", getText(n_("bow.bookmark.badFileFormat")));
		    request.setAttribute("errorMsgTech", e.getMessage());
		    redirectTo = BowUtils.redirectTo(searchLine, fullTextLine);

		    if (searchLine == null || searchLine.isEmpty()) {
			BowInit.initHomePage(request, user);
			return SUCCESS;
		    } else {
			try {
			    BowSearch.search(request, user);
			} catch (IOException e1) {
			    // TODO Auto-generated catch block
			    e1.printStackTrace();
			} catch (ServletException e1) {
			    // TODO Auto-generated catch block
			    e1.printStackTrace();
			}
			return SUCCESS;
		    } 
	    } catch (IOException e2) {
		// TODO Auto-generated catch block
		e2.printStackTrace();
	    return ERROR;
	    }
	}
	return SUCCESS;
    }
}