/*
 * #%L
 * bow
 * 
 * $Id: HomeAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/HomeAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowInit;
import org.chorem.bow.User;

/**
 * Prepare l'affichage de la page d'accueil
 * 
 * @author poussin
 */
public class HomeAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -3735250067223062719L;
    protected String token;
    protected HttpServletRequest request;
    
    /**
     * @return the token
     */
    public String getToken() {
        return token;
    }
    /**
     * @param token the token to set
     */
    public void setToken(String token) {
        this.token = token;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

    public String execute() {
	User user = getBowSession().getUser();
	
	BowInit.initHomePage(request, user);
	return SUCCESS;
    }
}