/*
 * #%L
 * bow
 * 
 * $Id: FullTextSearchAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/FullTextSearchAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowSearch;
import org.chorem.bow.BowSession;
import org.chorem.bow.User;

/**
 * Fait la recherche fulltext
 * 
 * @author poussin
 */
public class FullTextSearchAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -7736099487284993426L;
    protected String searchLine;
    protected String fullTextLine;
    protected HttpServletRequest request;

    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }
    
    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    public String execute() {
        BowSession session = getBowSession();
        User user = session.getUser();
	
	try {
	    BowSearch.fullText(request, user);
	} catch (IOException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	} catch (ServletException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
	return SUCCESS;
    }
}
