/*
 * #%L
 * bow
 * 
 * $Id: DeleteTagAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/DeleteTagAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.Bookmark;
import org.chorem.bow.BowUtils;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Supprime un tag d'un bookmark
 * 
 * @author poussin
 */
public class DeleteTagAction extends BowBaseAction {
    private static final long serialVersionUID = -6174966873862161966L;
    protected String bookmarkId;
    protected String deleteTag;
    protected String redirectTo;
    protected String searchLine;
    protected String fullTextLine;

    /**
     * @return the bookmarkId
     */
    public String getBookmarkId() {
        return bookmarkId;
    }
    /**
     * @param bookmarkId the bookmarkId to set
     */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }
    /**
     * @return the deleteTag
     */
    public String getDeleteTag() {
        return deleteTag;
    }
    /**
     * @param deleteTag the deleteTag to set
     */
    public void setDeleteTag(String deleteTag) {
        this.deleteTag = deleteTag;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    /**
     * @return the redirectTo
     */
    public String getRedirectTo() {
        return redirectTo;
    }

    public String execute() {
        if (deleteTag != null && bookmarkId != null) {
            if (!bookmarkId.isEmpty()) {
                WikittyProxy proxy = getBowProxy();
                Bookmark bookmark = proxy.restore(Bookmark.class, bookmarkId);

                if (bookmark != null) {
                    bookmark.removeTags(deleteTag);
                    proxy.store(bookmark);
                }
            }
        }
        redirectTo = BowUtils.redirectTo(searchLine, fullTextLine);
        return SUCCESS;
    }
}