/*
 * #%L
 * bow
 * 
 * $Id: UserMigration.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/UserMigration.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.WikittyImpl;

/**
 *
 * @author sherkhan
 */
public class UserMigration implements WikittyExtensionMigration {

    @Override
    public Wikitty migrate(WikittyService service,
                           Wikitty wikitty,
                           WikittyExtension oldExt,
                           WikittyExtension newExt) {

        // FIXME poussin 20110211 il y a un probleme, il faut checker la version
        // de l'extension old avant de faire le migration. Sinon on va migrer
        // des donnees deja migrees :(

        String id = wikitty.getId();
        String version = wikitty.getVersion();
        Wikitty newWikitty = new WikittyImpl(id);
        newWikitty.setVersion(version);

        List<WikittyExtension> extensions =
                new ArrayList<WikittyExtension>(wikitty.getExtensions());
        if (extensions.contains(oldExt)) {
            extensions.remove(oldExt);
            extensions.add(newExt);
        }
        newWikitty.addExtension(extensions);

        Set<String> fieldNames = wikitty.fieldNames();
        for (String fieldName : fieldNames) {
            Object obj = wikitty.getFqField(fieldName);
            if (fieldName.equals("User.password")) {
                String password = (String) obj;
                try {
                    password = StringUtil.encodeMD5(password);
                } catch (RuntimeException ex) {
                    throw new WikittyException("Could not encode password", ex);
                }
                obj = password;
            }
            newWikitty.setFqField(fieldName, obj);
        }

        return newWikitty;
    }
}
