/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class TokenAbstract extends BusinessEntityImpl implements Token {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionToken;
    /**
     * getToken :
     * @return String 
     */

    @Override
    public String getToken() {
        String value = TokenHelper.getToken(getWikitty());
        return value;
}

    /**
     * setToken :
     * @param token 
     */

    @Override
    public void setToken(String token) {
        String oldValue = getToken();
        TokenHelper.setToken(getWikitty(), token);
        getPropertyChangeSupport().firePropertyChange(Token.FIELD_TOKEN_TOKEN, oldValue, getToken());
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        String value = TokenHelper.getEmail(getWikitty());
        return value;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        String oldValue = getEmail();
        TokenHelper.setEmail(getWikitty(), email);
        getPropertyChangeSupport().firePropertyChange(Token.FIELD_TOKEN_EMAIL, oldValue, getEmail());
}

    /**
     * TokenAbstract :
     */

    public TokenAbstract() {
        super();
}

    /**
     * TokenAbstract :
     * @param wikitty 
     */

    public TokenAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * TokenAbstract :
     * @param businessEntityImpl 
     */

    public TokenAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionToken =
                new WikittyExtension(EXT_TOKEN,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String token unique=\"true\"", 
                                             "String email unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionToken);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //TokenAbstract
