/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class PreferenceAbstract extends BusinessEntityImpl implements Preference {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionPreference;
    /**
     * getTags :
     * @return int 
     */

    @Override
    public int getTags() {
        int value = PreferenceHelper.getTags(getWikitty());
        return value;
}

    /**
     * setTags :
     * @param tags 
     */

    @Override
    public void setTags(int tags) {
        int oldValue = getTags();
        PreferenceHelper.setTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(Preference.FIELD_PREFERENCE_TAGS, oldValue, getTags());
}

    /**
     * getBookmarks :
     * @return int 
     */

    @Override
    public int getBookmarks() {
        int value = PreferenceHelper.getBookmarks(getWikitty());
        return value;
}

    /**
     * setBookmarks :
     * @param bookmarks 
     */

    @Override
    public void setBookmarks(int bookmarks) {
        int oldValue = getBookmarks();
        PreferenceHelper.setBookmarks(getWikitty(), bookmarks);
        getPropertyChangeSupport().firePropertyChange(Preference.FIELD_PREFERENCE_BOOKMARKS, oldValue, getBookmarks());
}

    /**
     * getColors :
     * @return String 
     */

    @Override
    public String getColors() {
        String value = PreferenceHelper.getColors(getWikitty());
        return value;
}

    /**
     * setColors :
     * @param colors 
     */

    @Override
    public void setColors(String colors) {
        String oldValue = getColors();
        PreferenceHelper.setColors(getWikitty(), colors);
        getPropertyChangeSupport().firePropertyChange(Preference.FIELD_PREFERENCE_COLORS, oldValue, getColors());
}

    /**
     * getSearchEngineUrlSuggestions :
     * @return String 
     */

    @Override
    public String getSearchEngineUrlSuggestions() {
        String value = PreferenceHelper.getSearchEngineUrlSuggestions(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlSuggestions :
     * @param searchEngineUrlSuggestions 
     */

    @Override
    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        String oldValue = getSearchEngineUrlSuggestions();
        PreferenceHelper.setSearchEngineUrlSuggestions(getWikitty(), searchEngineUrlSuggestions);
        getPropertyChangeSupport().firePropertyChange(Preference.FIELD_PREFERENCE_SEARCHENGINEURLSUGGESTIONS, oldValue, getSearchEngineUrlSuggestions());
}

    /**
     * getSearchEngineUrlResults :
     * @return String 
     */

    @Override
    public String getSearchEngineUrlResults() {
        String value = PreferenceHelper.getSearchEngineUrlResults(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlResults :
     * @param searchEngineUrlResults 
     */

    @Override
    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        String oldValue = getSearchEngineUrlResults();
        PreferenceHelper.setSearchEngineUrlResults(getWikitty(), searchEngineUrlResults);
        getPropertyChangeSupport().firePropertyChange(Preference.FIELD_PREFERENCE_SEARCHENGINEURLRESULTS, oldValue, getSearchEngineUrlResults());
}

    /**
     * PreferenceAbstract :
     */

    public PreferenceAbstract() {
        super();
}

    /**
     * PreferenceAbstract :
     * @param wikitty 
     */

    public PreferenceAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * PreferenceAbstract :
     * @param businessEntityImpl 
     */

    public PreferenceAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionPreference =
                new WikittyExtension(EXT_PREFERENCE,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Numeric tags unique=\"true\"", 
                                             "Numeric bookmarks unique=\"true\"", 
                                             "String colors unique=\"true\"", 
                                             "String searchEngineUrlSuggestions unique=\"true\"", 
                                             "String searchEngineUrlResults unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionPreference);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //PreferenceAbstract
