/*
 * #%L
 * bow
 * 
 * $Id: BowUtils.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/BowUtils.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.security.NoSuchAlgorithmException;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

public class BowUtils {

    private BowUtils() {
    }

    static public String generateToken() {
        Double rand = Math.random() * 100000000;
        int res = (int) Math.abs(rand); // generate a token between 0 and 100 000 000
        String tokenGenerated = String.valueOf(res);
        tokenGenerated = StringUtil.encodeMD5(tokenGenerated); // encode the token in MD5
        return tokenGenerated; // return the generate token
    }


    static public String redirectTo(String searchLine, String fullTextLine) {
        if (!searchLine.equals("") || !fullTextLine.equals("")) {
            return "search.action?searchLine=" + searchLine + "&fullTextLine=" + fullTextLine;
        } else {
            return "home.action";
        }
    }
    
    static public User checkToken(BowSession session, String token) {
        User result = null;
        if (checkTemporaryToken(session, token) || checkPermanentToken(session, token)) {
            result = session.getUser();
        }
        return result;
    }

    /**
     * check if token exist, if true, put User associated with it, in BowSession
     *
     * @param token         String which contains the MD5 encoding token
     * @return null         the token doesn't exist
     * @return User         the token owner
     */
    protected static boolean checkPermanentToken(BowSession session, String token) {
        WikittyProxy proxy = session.getProxy();
        boolean result = false;
        if (token != null) {
            Criteria criteria = Search.query().eq(Token.FQ_FIELD_TOKEN_TOKEN, token).criteria();
            Token DbToken = proxy.findByCriteria(Token.class, criteria);

            if (DbToken != null) {  // check if the token exists
                String userEmail = DbToken.getEmail(); // the token owner user name (email)
                criteria = Search.query().eq(User.FQ_FIELD_USER_EMAIL, userEmail).criteria(); // retrieve user by token
                User user = proxy.findByCriteria(User.class, criteria);
                session.setUser(user);
                result = true;
            }
        }
        return result;
    }

    /**
     * Check token with temporary token
     *
     * @param token         String which contains the MD5 encoding token
     * @return null         the token doesn't exist
     * @return User         the token owner
     */
    protected static boolean checkTemporaryToken(BowSession session, String token) {
        String temporaryToken = session.getTemporaryToken();
        boolean result = temporaryToken != null && temporaryToken.equals(token);
        return result;
    }
}
