/*
 * #%L
 * bow
 * 
 * $Id: BowSession.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/BowSession.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;


import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

/**
 * Classe utilisee pour stocker les objets utils en session utilisateur
 *
 * @author poussin
 * @version $Revision: 192 $
 *
 * Last update: $Date: 2011-02-14 15:53:06 +0100 (lun., 14 févr. 2011) $
 * by : $Author: tchemit $
 */
public class BowSession {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(BowSession.class);

    static final private String BOW_SESSION_KEY = BowSession.class.getSimpleName();

    protected BowProxy proxy;
    protected User user = null;
    protected Preference preference = null;
    protected String permanentToken = null;
    protected String temporaryToken = null;
    protected boolean admin = false;

    public BowSession() {
        proxy = BowProxy.getInstance(null);
    }

    static public void invalidate(Map<String, Object> session) {
        session.remove(BOW_SESSION_KEY);
    }

    static public BowSession getBowSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        BowSession result = getBowSession(session);
        return result;
    }

    static public BowSession getBowSession(HttpSession httpSession) {
        BowSession result = (BowSession) httpSession.getAttribute(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            httpSession.setAttribute(BOW_SESSION_KEY, result);
        }
        return result;
    }

    static public BowSession getBowSession(Map<String, Object> session) {
        BowSession result = (BowSession)session.get(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            session.put(BOW_SESSION_KEY, result);
        }
        return result;
    }

    public BowProxy getProxy() {
        return proxy;
    }

    public Preference getPreference() {
        return preference;
    }

    public void setPreference(Preference preference) {
        this.preference = preference;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        // si c'est le meme user, on ne fait rien
        if (ObjectUtils.equals(this.user, user)) {
            return;
        }

        this.user = user;

        if (user != null) {
            // load user preference
            Preference preference = getProxy().restore(Preference.class, user.getWikittyId());
            checkPreference(preference);
            setPreference(preference);

            // check if this user is admin
            String email = user.getEmail();
            String[] admins = BowConfig.getInstance().getAdmins();
            boolean isAdmin = false;
            if (admins != null) {
                for (String admin : admins) {
                    if (email.equals(admin)) {
                        isAdmin = true;
                        break;
                    }
                }
            }
            setAdmin(isAdmin);

            // retrieve or generate permanent token
            loadToken();
        }
    }

    /**
     * if user is set. Load or create token for this user. temporary token
     * is regenerated
     */
    public void loadToken() {
        if (getUser() != null) {
            String email = getUser().getEmail();
            
            // retrieve or generate permanent token
            Criteria criteria = Search.query().eq(Token.FQ_FIELD_TOKEN_EMAIL, email).criteria();
            Token token = getProxy().findByCriteria(Token.class, criteria);
            if (token == null) {
                token = new TokenImpl();
                String newToken = BowUtils.generateToken();
                token.setToken(newToken);
                token.setEmail(email);
                token = proxy.store(token);
            }
            // generate new temporary token
            setPermanentToken(token.getToken());
            String temporaryToken = BowUtils.generateToken();
            setTemporaryToken(temporaryToken);
        }
    }

    protected void checkPreference(Preference preference) {
        if (preference.getBookmarks() <= 0) {
            preference.setBookmarks(100); // set default to 100
        }
        if (preference.getTags() <= 0) {
            preference.setTags(100); // set default to 100
        }
        if (preference.getColors() == null) {
            preference.setColors("");
        }
        if (preference.getSearchEngineUrlResults() == null) {
            preference.setSearchEngineUrlResults(BowConfig.getInstance().getSearchEngine());
        }
        if (preference.getSearchEngineUrlSuggestions() == null) {
            preference.setSearchEngineUrlSuggestions(""); // TODO add default value in config
        }
    }
    
    public String getPermanentToken() {
        return permanentToken;
    }

    public void setPermanentToken(String permanentToken) {
        this.permanentToken = permanentToken;
    }

    public String getTemporaryToken() {
        return temporaryToken;
    }

    public void setTemporaryToken(String temporaryToken) {
        this.temporaryToken = temporaryToken;
    }

    public boolean isAdmin() {
        return admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

}
