/*
 * #%L
 * bow
 * 
 * $Id: BowSearch.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/BowSearch.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

public class BowSearch {

    static public void search(HttpServletRequest request, User user)
            throws IOException, ServletException {
        String searchLine = request.getParameter("searchLine");

        if (searchLine == null) {
            searchLine = "";
        }
        String fulltext = request.getParameter("fullTextLine");

        if (fulltext != null && !fulltext.isEmpty() && searchLine.isEmpty()) {
            fullText(request, user);
        } else {
            String tag = request.getParameter("addTag");

            if (tag != null && !tag.isEmpty()) {
                if (searchLine.isEmpty()) {
                    searchLine = tag;
                } else {
                    searchLine += " " + tag;
                }
            }
            BowSession session = BowSession.getBowSession(request);
            WikittyProxy proxy = session.getProxy();
            Criteria criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);
            criteria = criteria.addSortDescending(Bookmark.FQ_FIELD_BOOKMARK_CLICK);

            if (criteria != null) {
                PagedResult<Bookmark> result = proxy.findAllByCriteria(Bookmark.class, criteria); //Selects all bookmarks by user
                BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, searchLine);
                request.setAttribute("bookmarkActions", bookmarkActions);
            }
        }
    }

    static public void fullText(HttpServletRequest request, User user) throws IOException, ServletException {
        String fullText = request.getParameter("fullTextLine");

        if (fullText == null || fullText.isEmpty()) {
            search(request, user);
        } else {
            BowSession session = BowSession.getBowSession(request);
            WikittyProxy proxy = session.getProxy();
            Criteria criteria;

            if (!fullText.isEmpty()) {
                criteria = Search.query().keyword(fullText).
                        eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail()).criteria().
                        addFacetField(Bookmark.FQ_FIELD_BOOKMARK_TAGS);
            } else {
                criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, null);
            }
            PagedResult<Bookmark> result = proxy.findAllByCriteria(Bookmark.class, criteria);
            BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, null);
            request.setAttribute("bookmarkActions", bookmarkActions);
        }
    }
}
