/*
 * #%L
 * bow
 * 
 * $Id: BowProxy.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/BowProxy.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.Arrays;
import java.util.List;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;

/**
 * Proxy pour utiliser les wikitty convenablement initialise.
 *
 * @author poussin
 * @version $Revision: 192 $
 *
 * Last update: $Date: 2011-02-14 15:53:06 +0100 (lun., 14 févr. 2011) $
 * by : $Author: tchemit $
 */
public class BowProxy extends WikittyProxy {

    static protected WikittyService ws = null;

    protected BowProxy(BowConfig config, WikittyService ws) {
        super(config, ws);
    }

    /**
     * Return instance of BowProxy with specified security token
     *
     * @param token
     * @return
     */
    static public BowProxy getInstance(String token) {
        BowConfig config = BowConfig.getInstance();
        WikittyService ws = getWikittyService(config);
        BowProxy result = new BowProxy(config, ws);
        result.setSecurityToken(token);
        
        return result;
    }

    /**
     * Return WikittyService to use. This WikittyService is singleton.
     *
     * @param config
     * @return
     */
    static protected WikittyService getWikittyService(ApplicationConfig config) {
        if (ws == null) {
            synchronized(BowProxy.class) {
                if (ws == null) {
                    /*
                     * Fixe me when wikitty will integrate this function
                     */
                    WikittyExtensionMigration.migrationRegistry.put(User.EXT_USER, new UserMigration());
                    
                    List<WikittyExtension> extensions = Arrays.asList(
                            UserImpl.extensionUser,
                            PreferenceImpl.extensionPreference,
                            BookmarkImpl.extensionBookmark,
                            TokenImpl.extensionToken);

                    ws = WikittyServiceFactory.buildWikittyService(config);
                    ws.storeExtension(null, extensions);
                }
            }
        }
        return ws;
    }
    
}
