/*
 * #%L
 * bow
 * 
 * $Id: BowInit.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/BowInit.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;

public class BowInit {

//    static public void checkAdmin(Map<String, Object> session, String login) {
//        String[] admins = BowConfig.getInstance().getAdmins();
//
//        boolean isAdmin = false;
//        if (admins != null) {
//            for (String admin : admins) {
//                if (login.equals(admin)) {
//                    isAdmin = true;
//                    break;
//                }
//            }
//        }
//        BowSession bowSession = BowSession.getBowSession(session);
//        bowSession.setAdmin(isAdmin);
//    }
//
//    /**
//     * load token if not already loaded, or create new bow token if token not
//     * found in data
//     *
//     * @param session
//     * @param login
//     * @throws NoSuchAlgorithmException
//     */
//    static public void initializeToken(Map<String, Object> session, User login)
//            throws NoSuchAlgorithmException {
//        BowSession bowSession = BowSession.getBowSession(session);
//        BowToken bowToken = bowSession.getBowToken();
//        if (bowToken == null) {
//            WikittyProxy proxy = bowSession.getProxy();
//            Criteria criteria = Search.query().eq(Token.FQ_FIELD_TOKEN_EMAIL, login.getEmail()).criteria();
//            Token token = proxy.findByCriteria(Token.class, criteria);
//            bowToken = new BowToken();
//
//            if (token == null) {
//                token = new TokenImpl();
//                String newToken = bowToken.generateToken();
//                token.setToken(newToken);
//                token.setEmail(login.getEmail());
//                proxy.store(token);
//            }
//            bowToken.setPermanentToken(token.getToken());
//            String temporaryToken = bowToken.generateToken();
//            bowToken.setTemporaryToken(temporaryToken);
//            bowSession.setBowToken(bowToken);
//        }
//    }

//    static public void initSession(Map<String, Object> session, User user) throws NoSuchAlgorithmException {
//        BowSession bowSession = BowSession.getBowSession(session);
////        WikittyProxy proxy = bowSession.getProxy();
//
//        if (user != null) {
//            bowSession.setUser(user);
//
//            // pas ajouter dans bowSession car, en a t on vraiment besoin ?
////            session.put("version", config.getVersion());
////            session.put("bowUrl", config.getBowUrl());
////            initializeToken(session, user);
////            checkAdmin(session, user.getEmail());
//        }
//    }
// 
    static public void initHomePage(HttpServletRequest request, User user) {
        BowSession session = BowSession.getBowSession(request);
        WikittyProxy proxy = session.getProxy();
        Criteria criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, null);

        if (criteria != null) {
            Criteria sortCriteria = criteria.addSortDescending(Bookmark.FQ_FIELD_BOOKMARK_CLICK);
            PagedResult<Bookmark> result = proxy.findAllByCriteria(Bookmark.class, sortCriteria); //Selects all bookmarks by user
            sortCriteria = criteria.addSortDescending(Bookmark.FQ_FIELD_BOOKMARK_DATE).setEndIndex(10);//TODO: remove hardcoded value
            List<Bookmark> lastBookmarks = proxy.findAllByCriteria(Bookmark.class, sortCriteria).getAll();
            BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, null);
            bookmarkActions.setTagSearch(null);
            List<Bookmark> bookList = bookmarkActions.getBookmarks();

            if (bookList.size() > 10) { //TODO: remove hardcoded value
                bookList = bookmarkActions.getBookmarks().subList(0, 10); //TODO: remove hardcoded value
                bookmarkActions.setBookmarks(bookList);
            }
            if (lastBookmarks != null) {
                bookmarkActions.setLastBookmarks(lastBookmarks);
            }
            request.setAttribute("bookmarkActions", bookmarkActions);
        }
    }
}
