package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class UserAbstract extends BusinessEntityWikitty implements User {

    private static final long serialVersionUID = 561949632L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionUser =
        new WikittyExtension(EXT_USER, "3.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String password",
				"String email"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionUser);

        extensions = Collections.unmodifiableList(exts);
    }

	public UserAbstract() {
		super();
	}

    public UserAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public UserAbstract(Wikitty wi) {
		super(wi);
	}


    public void setPassword(String password) {
        Object oldValue = getField(EXT_USER, "password");
        getWikitty().setField(EXT_USER, "password", password);
        getPropertyChangeSupport().firePropertyChange("password", oldValue, password);
    }

    public String getPassword() {
        String result = getWikitty().getFieldAsString(EXT_USER, "password");
        return result;
    }


    public void setEmail(String email) {
        Object oldValue = getField(EXT_USER, "email");
        getWikitty().setField(EXT_USER, "email", email);
        getPropertyChangeSupport().firePropertyChange("email", oldValue, email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_USER, "email");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_USER, FIELD_PASSWORD);
            Object f2 = w2.getFieldAsObject(EXT_USER, FIELD_PASSWORD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_USER, FIELD_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_USER, FIELD_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //UserAbstract
